/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.config;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.config.Configuration;

public final class Configurations {
    private static final QName COMPOSITE_QNAME = XMLHelper.createQName((String)"http://docs.oasis-open.org/ns/opencsa/sca/200912", (String)"composite");

    private Configurations() {
    }

    public static Configuration merge(Configuration fromConfig, Configuration toConfig) {
        return Configurations.merge(fromConfig, toConfig, true);
    }

    public static Configuration merge(Configuration fromConfig, Configuration toConfig, boolean fromOverridesTo) {
        QName toConfigQName;
        QName fromConfigQName = fromConfig.getQName();
        if (!fromConfigQName.equals(toConfigQName = toConfig.getQName())) {
            throw new IllegalArgumentException(fromConfigQName + " != " + toConfigQName);
        }
        fromConfig.normalize().orderChildren();
        toConfig.normalize().orderChildren();
        Configuration mergedConfig = toConfig.copy();
        Configurations.recursiveMerge(fromConfig.copy(), mergedConfig, fromOverridesTo);
        mergedConfig.orderChildren();
        return mergedConfig;
    }

    private static void recursiveMerge(Configuration from_config, Configuration merged_config, boolean from_overrides_merged) {
        String from_config_value;
        String from_config_attr_value;
        ArrayList<QName> merged_attr_qnames = new ArrayList<QName>();
        for (QName merged_config_attr_qname : merged_config.getAttributeQNames()) {
            if (from_overrides_merged) {
                from_config_attr_value = from_config.getAttribute(merged_config_attr_qname);
                if (from_config_attr_value == null) continue;
                merged_config.setAttribute(merged_config_attr_qname, from_config_attr_value);
                merged_attr_qnames.add(merged_config_attr_qname);
                continue;
            }
            merged_attr_qnames.add(merged_config_attr_qname);
        }
        for (QName from_config_attr_qname : from_config.getAttributeQNames()) {
            if (merged_attr_qnames.contains(from_config_attr_qname)) continue;
            from_config_attr_value = from_config.getAttribute(from_config_attr_qname);
            merged_config.setAttribute(from_config_attr_qname, from_config_attr_value);
            merged_attr_qnames.add(from_config_attr_qname);
        }
        if (from_overrides_merged && (from_config_value = from_config.getValue()) != null && from_config_value.length() > 0) {
            merged_config.setValue(from_config_value);
        }
        LinkedHashMap<Key, Configuration> merged_config_orphans = new LinkedHashMap<Key, Configuration>();
        for (Configuration merged_config_child : merged_config.getChildren()) {
            Key merged_config_child_key = new Key(merged_config_child);
            merged_config_orphans.put(merged_config_child_key, merged_config_child);
        }
        merged_config.removeChildren();
        for (Configuration from_config_child : from_config.getChildren()) {
            Key from_config_child_key = new Key(from_config_child);
            Configuration merged_config_orphan = (Configuration)merged_config_orphans.remove(from_config_child_key);
            if (merged_config_orphan != null) {
                Configurations.recursiveMerge(from_config_child, merged_config_orphan, from_overrides_merged);
                merged_config.addChild(merged_config_orphan);
                continue;
            }
            if (COMPOSITE_QNAME.equals(from_config_child.getQName())) {
                boolean candidate_found = false;
                for (Map.Entry merged_config_orphan_entry : merged_config_orphans.entrySet()) {
                    Configuration merged_config_orphan_candidate = (Configuration)merged_config_orphan_entry.getValue();
                    if (!COMPOSITE_QNAME.equals(merged_config_orphan_candidate.getQName())) continue;
                    candidate_found = true;
                    merged_config_orphans.remove(merged_config_orphan_entry.getKey());
                    String from_config_child_name_attr = from_config_child.getAttribute("name");
                    if (from_config_child_name_attr != null && from_config_child_name_attr.length() > 0) {
                        merged_config_orphan_candidate.setAttribute("name", from_config_child_name_attr);
                    }
                    Configurations.recursiveMerge(from_config_child, merged_config_orphan_candidate, from_overrides_merged);
                    merged_config.addChild(merged_config_orphan_candidate);
                    break;
                }
                if (candidate_found) continue;
                merged_config.addChild(from_config_child);
                continue;
            }
            merged_config.addChild(from_config_child);
        }
        for (Configuration merged_config_orphan : merged_config_orphans.values()) {
            merged_config.addChild(merged_config_orphan);
        }
    }

    private static final class Key {
        private static final String[] ID_CANDIDATES = new String[]{"id", "name", "type", "class", "interface", "from", "to"};
        private QName _qname;
        private Map<String, Object> _ids;

        private Key(Configuration config) {
            this._qname = config.getQName();
            this._ids = new TreeMap<String, Object>();
            for (String idc : ID_CANDIDATES) {
                String id = Strings.trimToNull((String)config.getAttribute(XMLHelper.createQName((String)this._qname.getNamespaceURI(), (String)idc)));
                if (id == null) {
                    id = Strings.trimToNull((String)config.getAttribute(idc));
                }
                if (id == null) continue;
                this._ids.put(idc, id);
            }
        }

        public String toString() {
            return "Key [_qname=" + this._qname + ", _ids=" + this._ids + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._ids == null ? 0 : ((Object)this._ids).hashCode());
            result = 31 * result + (this._qname == null ? 0 : this._qname.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this._ids == null ? other._ids != null : !((Object)this._ids).equals(other._ids)) {
                return false;
            }
            return !(this._qname == null ? other._qname != null : !this._qname.equals(other._qname));
        }
    }
}

