/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.sca;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Servlet;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.osgi.service.http.HttpService;
import org.switchyard.ServiceDomain;
import org.switchyard.component.sca.RemoteEndpointPublisher;
import org.switchyard.component.sca.SwitchYardRemotingServlet;

public class OsgiRemoteEndpointPublisher
implements RemoteEndpointPublisher {
    private HttpService _httpService;
    private boolean _started;
    private String _contextName;
    private String _address;
    private int _port;
    private Map<QName, ServiceDomain> _services = new ConcurrentHashMap<QName, ServiceDomain>();
    private boolean _disableRemoteTransaction = false;
    private static Logger _log = Logger.getLogger(OsgiRemoteEndpointPublisher.class);

    public void setHttpService(HttpService httpService) {
        this._httpService = httpService;
    }

    @Override
    public void init(String context) {
        this._contextName = context;
    }

    @Override
    public synchronized void start() throws Exception {
        if (this._started) {
            return;
        }
        if (this._address == null || this._address.trim().length() == 0) {
            this._address = this.createEndpointURL();
        }
        SwitchYardRemotingServlet servlet = new SwitchYardRemotingServlet();
        servlet.setEndpointPublisher(this);
        this._httpService.registerServlet("/" + this._contextName, (Servlet)servlet, null, null);
        this._started = true;
    }

    @Override
    public synchronized void stop() throws Exception {
        this._started = false;
    }

    @Override
    public void addService(QName serviceName, ServiceDomain domain) {
        this._services.put(serviceName, domain);
    }

    @Override
    public void removeService(QName serviceName, ServiceDomain domain) {
        this._services.remove(serviceName);
    }

    @Override
    public ServiceDomain getDomain(QName serviceName) {
        return this._services.get(serviceName);
    }

    @Override
    public String getAddress() {
        return this._address;
    }

    @Override
    public RemoteEndpointPublisher setDisableRemoteTransaction(boolean disable) {
        this._disableRemoteTransaction = disable;
        return this;
    }

    @Override
    public boolean isDisableRemoteTransaction() {
        return this._disableRemoteTransaction;
    }

    public void setAddress(String address) {
        this._address = address;
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int port) {
        this._port = port;
    }

    private String createEndpointURL() {
        String host;
        try {
            host = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException hostEx) {
            _log.debug((Object)"Unable to determine host IP for remote endpoint URL", (Throwable)hostEx);
            host = "localhost";
        }
        return "http://" + host + ":" + this._port + "/" + this._contextName;
    }
}

