/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.resteasy.resource;

import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.resteasy.plugins.server.sun.http.HttpContextBuilder;
import org.switchyard.ServiceDomain;
import org.switchyard.component.common.Endpoint;
import org.switchyard.component.resteasy.RestEasyLogger;
import org.switchyard.component.resteasy.resource.ResourcePublisher;
import org.switchyard.component.resteasy.resource.StandaloneResource;
import org.switchyard.component.resteasy.util.RESTEasyUtil;

public class StandaloneResourcePublisher
implements ResourcePublisher {
    private static final Logger LOGGER = Logger.getLogger(StandaloneResourcePublisher.class);
    private static HttpServer _httpServer;
    private static HttpContextBuilder _contextBuilder;

    @Override
    public Endpoint publish(ServiceDomain domain, final String context, final List<Object> instances, Map<String, String> contextParams) throws Exception {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("Publishing StandaloneResource: context=" + context + ", resources=" + instances + ", contextParams=" + contextParams));
        }
        List<Object> resourceInstances = new ArrayList<Object>();
        String path = _contextBuilder.getPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.equals(context)) {
            block7: {
                _contextBuilder.cleanup();
                try {
                    _httpServer.removeContext(_contextBuilder.getPath());
                }
                catch (IllegalArgumentException iae) {
                    if (!LOGGER.isDebugEnabled()) break block7;
                    LOGGER.debug((Object)"", (Throwable)iae);
                }
            }
            resourceInstances = _contextBuilder.getDeployment().getResources();
            _contextBuilder.getDeployment().getDefaultContextObjects().clear();
        }
        for (Object instance : instances) {
            resourceInstances.add(instance);
        }
        _contextBuilder.getDeployment().setResources(resourceInstances);
        final List<String> providers = RESTEasyUtil.getParamValues(contextParams, "resteasy.providers");
        _contextBuilder.getDeployment().setScannedProviderClasses(providers != null ? providers : Collections.emptyList());
        _contextBuilder.setPath(context);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("Published StandaloneResource - Refreshing Sun HTTP Server: context=" + context + ", resources=" + resourceInstances + ", providers=" + providers));
        }
        _contextBuilder.bind(_httpServer);
        return new StandaloneResource(new StandaloneResource.Callback(){

            @Override
            public void onStart() {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)("Starting StandaloneResource: context=" + context + ", resources=" + instances + ", providers=" + providers));
                }
            }

            @Override
            public void onStop() {
                int i;
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)("Stopping StandaloneResource: context=" + context + ", resouces=" + instances + ", providers=" + providers));
                }
                ArrayList resources = new ArrayList(_contextBuilder.getDeployment().getResources());
                ArrayList scannedProviderClasses = new ArrayList(_contextBuilder.getDeployment().getScannedProviderClasses());
                String path = _contextBuilder.getPath();
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if (path.equals(context)) {
                    _contextBuilder.cleanup();
                    try {
                        _httpServer.removeContext(_contextBuilder.getPath());
                    }
                    catch (IllegalArgumentException iae) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)"", (Throwable)iae);
                        }
                        _contextBuilder.getDeployment().getDefaultContextObjects().clear();
                    }
                }
                for (i = 0; instances != null && i < instances.size(); ++i) {
                    if (instances.get(i) == null) continue;
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace((Object)("Removing RESTEasy Resource: " + instances.get(i)));
                    }
                    resources.remove(instances.get(i));
                }
                _contextBuilder.getDeployment().setResources(resources);
                for (i = 0; providers != null && i < providers.size(); ++i) {
                    if (providers.get(i) == null) continue;
                    scannedProviderClasses.remove(providers.get(i));
                }
                _contextBuilder.getDeployment().setScannedProviderClasses(scannedProviderClasses);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)("Stopped StandaloneResource - Refreshing Sun HTTP Server: context=" + context + ", resources=" + resources + ", providers=" + scannedProviderClasses));
                }
                _contextBuilder.setPath(context);
                _contextBuilder.bind(_httpServer);
            }
        });
    }

    static int getPort() {
        return Integer.getInteger("org.switchyard.component.resteasy.standalone.port", 8080);
    }

    static {
        try {
            _contextBuilder = new HttpContextBuilder();
            _httpServer = HttpServer.create(new InetSocketAddress(StandaloneResourcePublisher.getPort()), 10);
            _httpServer.setExecutor(null);
            _httpServer.start();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("Started Sun HttpServer at port " + StandaloneResourcePublisher.getPort()));
            }
        }
        catch (IOException ioe) {
            RestEasyLogger.ROOT_LOGGER.unableToLaunchStandaloneHttpServer(ioe);
        }
    }
}

