/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.quartz.deploy;

import java.io.IOException;
import java.net.URL;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.camel.component.quartz.QuartzComponent;
import org.switchyard.common.camel.SwitchYardCamelContext;
import org.switchyard.common.type.Classes;
import org.switchyard.component.camel.common.deploy.BaseBindingActivator;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.deploy.ServiceHandler;

public class CamelQuartzActivator
extends BaseBindingActivator {
    public CamelQuartzActivator(SwitchYardCamelContext context, String[] types) {
        super(context, types);
    }

    public ServiceHandler activateBinding(QName serviceName, BindingModel config) {
        this.probeQuartzProperties();
        return super.activateBinding(serviceName, config);
    }

    private void probeQuartzProperties() {
        try {
            URL props = Classes.getResource((String)"org/quartz/quartz.properties");
            if (props == null) {
                return;
            }
        }
        catch (IOException e) {
            return;
        }
        Set components = this.getCamelContext().getRegistry().findByType(QuartzComponent.class);
        if (components.isEmpty()) {
            QuartzComponent quartz = (QuartzComponent)this.getCamelContext().getInjector().newInstance(QuartzComponent.class);
            this.getCamelContext().getWritebleRegistry().put((Object)"quartz", (Object)quartz);
            components.add(quartz);
        }
        for (QuartzComponent quartz : components) {
            if (quartz.getPropertiesFile() != null) continue;
            quartz.setPropertiesFile("org/quartz/quartz.properties");
        }
    }
}

