/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.webserviceref;

import java.lang.reflect.AccessibleObject;
import java.util.List;
import java.util.Locale;
import javax.xml.ws.Service;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.FieldInjectionTarget;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.InjectionTarget;
import org.jboss.as.ee.component.LookupInjectionSource;
import org.jboss.as.ee.component.MethodInjectionTarget;
import org.jboss.as.ee.component.ResourceInjectionConfiguration;
import org.jboss.as.ee.utils.InjectionUtils;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.as.webservices.WSMessages;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.DotNames;
import org.jboss.as.webservices.util.VirtualFileAdaptor;
import org.jboss.as.webservices.webserviceref.WSRefAnnotationWrapper;
import org.jboss.as.webservices.webserviceref.WSRefUtils;
import org.jboss.as.webservices.webserviceref.WSRefValueSource;
import org.jboss.as.webservices.webserviceref.WSReferences;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.modules.Module;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;

public class WSRefAnnotationProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        List<AnnotationInstance> webServiceRefAnnotations = ASHelper.getAnnotations(unit, DotNames.WEB_SERVICE_REF_ANNOTATION);
        for (AnnotationInstance annotation : webServiceRefAnnotations) {
            AnnotationTarget annotationTarget = annotation.target();
            WSRefAnnotationWrapper annotationWrapper = new WSRefAnnotationWrapper(annotation);
            if (annotationTarget instanceof FieldInfo) {
                WSRefAnnotationProcessor.processFieldRef(unit, annotationWrapper, (FieldInfo)annotationTarget);
                continue;
            }
            if (annotationTarget instanceof MethodInfo) {
                WSRefAnnotationProcessor.processMethodRef(unit, annotationWrapper, (MethodInfo)annotationTarget);
                continue;
            }
            if (!(annotationTarget instanceof ClassInfo)) continue;
            WSRefAnnotationProcessor.processClassRef(unit, annotationWrapper, (ClassInfo)annotationTarget);
        }
        List<AnnotationInstance> webServiceRefsAnnotations = ASHelper.getAnnotations(unit, DotNames.WEB_SERVICE_REFS_ANNOTATION);
        for (AnnotationInstance outerAnnotation : webServiceRefsAnnotations) {
            AnnotationInstance[] values;
            AnnotationTarget annotationTarget = outerAnnotation.target();
            if (!(annotationTarget instanceof ClassInfo)) continue;
            for (AnnotationInstance annotation : values = outerAnnotation.value("value").asNestedArray()) {
                WSRefAnnotationWrapper annotationWrapper = new WSRefAnnotationWrapper(annotation);
                WSRefAnnotationProcessor.processClassRef(unit, annotationWrapper, (ClassInfo)annotationTarget);
            }
        }
    }

    public void undeploy(DeploymentUnit unit) {
    }

    private static void processFieldRef(DeploymentUnit unit, WSRefAnnotationWrapper annotation, FieldInfo fieldInfo) throws DeploymentUnitProcessingException {
        String fieldName = fieldInfo.name();
        String injectionType = WSRefAnnotationProcessor.isEmpty(annotation.type()) || annotation.type().equals(Object.class.getName()) ? fieldInfo.type().name().toString() : annotation.type();
        FieldInjectionTarget injectionTarget = new FieldInjectionTarget(fieldInfo.declaringClass().name().toString(), fieldName, injectionType);
        String bindingName = WSRefAnnotationProcessor.isEmpty(annotation.name()) ? fieldInfo.declaringClass().name().toString() + "/" + fieldInfo.name() : annotation.name();
        WSRefAnnotationProcessor.processRef(unit, injectionType, annotation, fieldInfo.declaringClass(), (InjectionTarget)injectionTarget, bindingName);
    }

    private static void processMethodRef(DeploymentUnit unit, WSRefAnnotationWrapper annotation, MethodInfo methodInfo) throws DeploymentUnitProcessingException {
        String methodName = methodInfo.name();
        if (!methodName.startsWith("set") || methodInfo.args().length != 1) {
            throw WSMessages.MESSAGES.invalidServiceRefSetterMethodName(methodInfo);
        }
        String injectionType = WSRefAnnotationProcessor.isEmpty(annotation.type()) || annotation.type().equals(Object.class.getName()) ? methodInfo.args()[0].name().toString() : annotation.type();
        MethodInjectionTarget injectionTarget = new MethodInjectionTarget(methodInfo.declaringClass().name().toString(), methodName, injectionType);
        String bindingName = WSRefAnnotationProcessor.isEmpty(annotation.name()) ? methodInfo.declaringClass().name().toString() + "/" + methodName.substring(3, 4).toLowerCase(Locale.ENGLISH) + methodName.substring(4) : annotation.name();
        WSRefAnnotationProcessor.processRef(unit, injectionType, annotation, methodInfo.declaringClass(), (InjectionTarget)injectionTarget, bindingName);
    }

    private static void processClassRef(DeploymentUnit unit, WSRefAnnotationWrapper annotation, ClassInfo classInfo) throws DeploymentUnitProcessingException {
        if (WSRefAnnotationProcessor.isEmpty(annotation.name())) {
            throw WSMessages.MESSAGES.requiredServiceRefName();
        }
        if (WSRefAnnotationProcessor.isEmpty(annotation.type())) {
            throw WSMessages.MESSAGES.requiredServiceRefType();
        }
        WSRefAnnotationProcessor.processRef(unit, annotation.type(), annotation, classInfo, null, annotation.name());
    }

    private static void processRef(DeploymentUnit unit, String type, WSRefAnnotationWrapper annotation, ClassInfo classInfo, InjectionTarget injectionTarget, String bindingName) throws DeploymentUnitProcessingException {
        boolean isEJB = false;
        EEModuleDescription moduleDescription = (EEModuleDescription)unit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        String componentClassName = classInfo.name().toString();
        Module module = (Module)unit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        for (ComponentDescription componentDescription : moduleDescription.getComponentsByClassName(componentClassName)) {
            if (!(componentDescription instanceof SessionBeanComponentDescription)) continue;
            isEJB = true;
            UnifiedServiceRefMetaData serviceRefUMDM = WSRefAnnotationProcessor.getServiceRef(unit, componentDescription, bindingName);
            WSRefAnnotationProcessor.initServiceRef(unit, serviceRefUMDM, type, annotation);
            WSRefAnnotationProcessor.processWSFeatures(unit, serviceRefUMDM, injectionTarget, classInfo);
            WSRefValueSource serviceRefSource = new WSRefValueSource(serviceRefUMDM, (ClassLoader)module.getClassLoader());
            BindingConfiguration bindingConfiguration = new BindingConfiguration(bindingName, (InjectionSource)serviceRefSource);
            componentDescription.getBindingConfigurations().add(bindingConfiguration);
            ResourceInjectionConfiguration injectionConfiguration = injectionTarget != null ? new ResourceInjectionConfiguration(injectionTarget, (InjectionSource)new LookupInjectionSource(bindingName)) : null;
            if (injectionConfiguration == null) continue;
            componentDescription.addResourceInjection(injectionConfiguration);
        }
        if (!isEJB) {
            ResourceInjectionConfiguration injectionConfiguration;
            UnifiedServiceRefMetaData serviceRefUMDM = WSRefAnnotationProcessor.getServiceRef(unit, null, bindingName);
            WSRefAnnotationProcessor.initServiceRef(unit, serviceRefUMDM, type, annotation);
            WSRefAnnotationProcessor.processWSFeatures(unit, serviceRefUMDM, injectionTarget, classInfo);
            EEModuleClassDescription classDescription = moduleDescription.addOrGetLocalClassDescription(classInfo.name().toString());
            WSRefValueSource serviceRefSource = new WSRefValueSource(serviceRefUMDM, (ClassLoader)module.getClassLoader());
            BindingConfiguration bindingConfiguration = new BindingConfiguration(bindingName, (InjectionSource)serviceRefSource);
            classDescription.getBindingConfigurations().add(bindingConfiguration);
            ResourceInjectionConfiguration resourceInjectionConfiguration = injectionConfiguration = injectionTarget != null ? new ResourceInjectionConfiguration(injectionTarget, (InjectionSource)new LookupInjectionSource(bindingName)) : null;
            if (injectionConfiguration != null) {
                classDescription.addResourceInjection(injectionConfiguration);
            }
        }
    }

    private static void processWSFeatures(DeploymentUnit unit, UnifiedServiceRefMetaData serviceRefUMDM, InjectionTarget injectionTarget, ClassInfo classInfo) throws DeploymentUnitProcessingException {
        if (injectionTarget != null) {
            WSRefAnnotationProcessor.processInjectionTarget(unit, serviceRefUMDM, injectionTarget);
        } else {
            WSRefAnnotationProcessor.processInjectionTarget(unit, serviceRefUMDM, classInfo);
        }
    }

    private static UnifiedServiceRefMetaData getServiceRef(DeploymentUnit unit, ComponentDescription componentDescription, String serviceRefName) {
        String cacheKey;
        WSReferences wsRefRegistry = ASHelper.getWSRefRegistry(unit);
        UnifiedServiceRefMetaData serviceRefUMDM = wsRefRegistry.get(cacheKey = WSRefAnnotationProcessor.getCacheKey(componentDescription, serviceRefName));
        if (serviceRefUMDM == null) {
            serviceRefUMDM = new UnifiedServiceRefMetaData(WSRefAnnotationProcessor.getUnifiedVirtualFile(unit));
            serviceRefUMDM.setServiceRefName(serviceRefName);
            wsRefRegistry.add(cacheKey, serviceRefUMDM);
        }
        return serviceRefUMDM;
    }

    private static String getCacheKey(ComponentDescription componentDescription, String serviceRefName) {
        if (componentDescription == null) {
            return serviceRefName;
        }
        return componentDescription.getComponentName() + "/" + serviceRefName;
    }

    private static void processInjectionTarget(DeploymentUnit unit, UnifiedServiceRefMetaData serviceRefUMDM, ClassInfo classInfo) throws DeploymentUnitProcessingException {
        Module module = (Module)unit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        Class<?> target = WSRefAnnotationProcessor.getClass((ClassLoader)module.getClassLoader(), classInfo.name().toString());
        WSRefUtils.processAnnotatedElement(target, serviceRefUMDM);
    }

    private static void processInjectionTarget(DeploymentUnit unit, UnifiedServiceRefMetaData serviceRefUMDM, InjectionTarget injectionTarget) throws DeploymentUnitProcessingException {
        Module module = (Module)unit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        DeploymentReflectionIndex deploymentReflectionIndex = (DeploymentReflectionIndex)unit.getAttachment(org.jboss.as.server.deployment.Attachments.REFLECTION_INDEX);
        String injectionTargetClassName = injectionTarget.getClassName();
        String injectionTargetName = WSRefAnnotationProcessor.getInjectionTargetName(injectionTarget);
        AccessibleObject fieldOrMethod = InjectionUtils.getInjectionTarget((String)injectionTargetClassName, (String)injectionTargetName, (ClassLoader)module.getClassLoader(), (DeploymentReflectionIndex)deploymentReflectionIndex);
        WSRefUtils.processAnnotatedElement(fieldOrMethod, serviceRefUMDM);
    }

    private static String getInjectionTargetName(InjectionTarget injectionTarget) {
        String name = injectionTarget.getName();
        if (injectionTarget instanceof FieldInjectionTarget) {
            return name;
        }
        if (injectionTarget instanceof MethodInjectionTarget) {
            return name.substring(3, 4).toUpperCase(Locale.ENGLISH) + name.substring(4);
        }
        throw new UnsupportedOperationException();
    }

    private static UnifiedServiceRefMetaData initServiceRef(DeploymentUnit unit, UnifiedServiceRefMetaData serviceRefUMDM, String type, WSRefAnnotationWrapper annotation) throws DeploymentUnitProcessingException {
        if (!WSRefAnnotationProcessor.isEmpty(annotation.wsdlLocation())) {
            serviceRefUMDM.setWsdlFile(annotation.wsdlLocation());
        }
        Module module = (Module)unit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        Class<?> typeClass = WSRefAnnotationProcessor.getClass((ClassLoader)module.getClassLoader(), type);
        serviceRefUMDM.setServiceRefType(typeClass.getName());
        if (!WSRefAnnotationProcessor.isEmpty(annotation.value())) {
            serviceRefUMDM.setServiceInterface(annotation.value());
        } else if (Service.class.isAssignableFrom(typeClass)) {
            serviceRefUMDM.setServiceInterface(typeClass.getName());
        } else {
            serviceRefUMDM.setServiceInterface(Service.class.getName());
        }
        WSRefUtils.processType(serviceRefUMDM);
        return serviceRefUMDM;
    }

    private static Class<?> getClass(ClassLoader classLoader, String className) throws DeploymentUnitProcessingException {
        if (!WSRefAnnotationProcessor.isEmpty(className)) {
            try {
                return classLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentUnitProcessingException((Throwable)e);
            }
        }
        return null;
    }

    private static UnifiedVirtualFile getUnifiedVirtualFile(DeploymentUnit unit) {
        ResourceRoot resourceRoot = (ResourceRoot)unit.getAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_ROOT);
        return new VirtualFileAdaptor(resourceRoot.getRoot());
    }

    private static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }
}

