/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.decoders;

import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Properties;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.javabean.decoders.LocaleAwareDecoder;

public abstract class LocaleAwareDateDecoder
extends LocaleAwareDecoder {
    public static final String FORMAT = "format";
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String LOCALE_LANGUAGE_CODE = "locale-language";
    public static final String LOCALE_COUNTRY_CODE = "locale-country";
    public static final String VERIFY_LOCALE = "verify-locale";
    protected String format;
    protected SimpleDateFormat decoder = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public void setConfiguration(Properties resourceConfig) throws SmooksConfigurationException {
        super.setConfiguration(resourceConfig);
        this.format = resourceConfig.getProperty(FORMAT, DEFAULT_DATE_FORMAT);
        if (this.format == null) {
            throw new SmooksConfigurationException("Decoder must specify a 'format' parameter.");
        }
        Locale configuredLocale = this.getLocale();
        this.decoder = configuredLocale != null ? new SimpleDateFormat(this.format.trim(), configuredLocale) : new SimpleDateFormat(this.format.trim());
    }
}

