/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security.provider;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.acl.Group;
import java.util.Collections;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.switchyard.ServiceSecurity;
import org.switchyard.common.type.reflect.Construction;
import org.switchyard.security.BaseSecurityLogger;
import org.switchyard.security.callback.handler.NamePasswordCallbackHandler;
import org.switchyard.security.callback.handler.SwitchYardCallbackHandler;
import org.switchyard.security.context.SecurityContext;
import org.switchyard.security.credential.SubjectCredential;
import org.switchyard.security.principal.GroupPrincipal;
import org.switchyard.security.principal.RolePrincipal;
import org.switchyard.security.provider.SecurityProvider;

public class DefaultSecurityProvider
implements SecurityProvider {
    @Override
    public boolean authenticate(ServiceSecurity serviceSecurity, SecurityContext securityContext) {
        CallbackHandler ch;
        boolean success = false;
        Class<NamePasswordCallbackHandler> ch_clazz = serviceSecurity.getCallbackHandler();
        if (ch_clazz == null) {
            ch_clazz = NamePasswordCallbackHandler.class;
        }
        if ((ch = (CallbackHandler)Construction.construct(ch_clazz)) instanceof SwitchYardCallbackHandler) {
            SwitchYardCallbackHandler sych = (SwitchYardCallbackHandler)ch;
            sych.setProperties(serviceSecurity.getProperties());
            sych.setCredentials(securityContext.getCredentials());
        }
        String securityDomain = serviceSecurity.getSecurityDomain();
        Subject subject = securityContext.getSubject(securityDomain);
        try {
            new LoginContext(securityDomain, subject, ch).login();
            success = true;
        }
        catch (LoginException le) {
            BaseSecurityLogger.ROOT_LOGGER.authenticateLoginException(le.getMessage(), le);
        }
        return success;
    }

    @Override
    public void populate(ServiceSecurity serviceSecurity, SecurityContext securityContext) {
        String securityDomain = serviceSecurity.getSecurityDomain();
        Subject toSubject = securityContext.getSubject(securityDomain);
        Set<SubjectCredential> subjectCredentials = securityContext.getCredentials(SubjectCredential.class);
        for (SubjectCredential subjectCredential : subjectCredentials) {
            Subject fromSubject = subjectCredential.getSubject();
            this.transfer(fromSubject, toSubject);
        }
    }

    protected void transfer(Subject fromSubject, Subject toSubject) {
        if (toSubject != null && fromSubject != null && toSubject != fromSubject && !toSubject.equals(fromSubject)) {
            Set<Principal> toPrincipals = toSubject.getPrincipals();
            Group toRolesGroup = null;
            for (Principal fromPrincipal : fromSubject.getPrincipals()) {
                if (fromPrincipal instanceof Group && "Roles".equals(fromPrincipal.getName())) {
                    Group fromRolesGroup = (Group)fromPrincipal;
                    if (toRolesGroup == null) {
                        toRolesGroup = this.getRolesGroup(toSubject);
                    }
                    if (toRolesGroup == fromRolesGroup) continue;
                    for (Principal fromRole : Collections.list(fromRolesGroup.members())) {
                        RolePrincipal toRole = fromRole instanceof RolePrincipal ? (RolePrincipal)fromRole : new RolePrincipal(fromRole.getName());
                        toRolesGroup.addMember((Principal)toRole);
                    }
                    continue;
                }
                toPrincipals.add(fromPrincipal);
            }
            toSubject.getPrivateCredentials().addAll(fromSubject.getPrivateCredentials());
            toSubject.getPublicCredentials().addAll(fromSubject.getPublicCredentials());
        }
    }

    @Override
    public boolean checkRolesAllowed(ServiceSecurity serviceSecurity, SecurityContext securityContext) {
        Set rolesAllowed = serviceSecurity.getRolesAllowed();
        if (rolesAllowed.isEmpty()) {
            return true;
        }
        String securityDomain = serviceSecurity.getSecurityDomain();
        for (String roleName : rolesAllowed) {
            boolean isInRole = securityContext.isCallerInRole(roleName, securityDomain);
            if (!isInRole) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T runAs(ServiceSecurity serviceSecurity, SecurityContext securityContext, PrivilegedExceptionAction<T> action) throws Exception {
        Object previous;
        T t;
        block4: {
            t = null;
            final String securityDomain = serviceSecurity.getSecurityDomain();
            final Subject subject = securityContext.getSubject(securityDomain);
            final Principal principal = securityContext.getCallerPrincipal(securityDomain);
            final Group rolesGroup = this.getRolesGroup(subject);
            RolePrincipal runAsPrincipal = null;
            boolean runAsAdded = false;
            final String runAs = serviceSecurity.getRunAs();
            if (runAs != null && !rolesGroup.isMember((Principal)(runAsPrincipal = new RolePrincipal(runAs)))) {
                rolesGroup.addMember((Principal)runAsPrincipal);
                runAsAdded = true;
            }
            previous = null;
            try {
                previous = this.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        return DefaultSecurityProvider.this.setContainerContext(securityDomain, subject, principal, rolesGroup, runAs);
                    }
                });
                t = Subject.doAsPrivileged(subject, action, null);
                if (!runAsAdded) break block4;
            }
            catch (Throwable throwable) {
                if (runAsAdded) {
                    rolesGroup.removeMember((Principal)runAsPrincipal);
                }
                Object p = previous;
                this.doPrivileged(new PrivilegedExceptionAction<Object>(p){
                    final /* synthetic */ Object val$p;
                    {
                        this.val$p = object;
                    }

                    @Override
                    public Object run() throws Exception {
                        DefaultSecurityProvider.this.resetContainerContext(this.val$p);
                        return null;
                    }
                });
                throw throwable;
            }
            rolesGroup.removeMember((Principal)runAsPrincipal);
        }
        Object p = previous;
        this.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        return t;
    }

    private final <T> T doPrivileged(PrivilegedExceptionAction<T> action) throws Exception {
        if (System.getSecurityManager() != null) {
            try {
                return AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        }
        return action.run();
    }

    protected Object setContainerContext(String securityDomain, Subject subject, Principal principal, Group rolesGroup, String runAs) throws Exception {
        return null;
    }

    protected void resetContainerContext(Object previous) throws Exception {
    }

    private Group getRolesGroup(Subject subject) {
        GroupPrincipal rolesGroup = null;
        Set<Group> groups = subject.getPrincipals(Group.class);
        for (Group group : groups) {
            if (!"Roles".equals(group.getName())) continue;
            rolesGroup = group;
            break;
        }
        if (rolesGroup == null) {
            rolesGroup = new GroupPrincipal("Roles");
            subject.getPrincipals().add((Principal)((Object)rolesGroup));
        }
        return rolesGroup;
    }

    @Override
    public void clear(ServiceSecurity serviceSecurity, SecurityContext securityContext) {
        String securityDomain;
        if (serviceSecurity != null && (securityDomain = serviceSecurity.getSecurityDomain()) != null) {
            securityContext.clearSubject(securityDomain);
        }
    }
}

