/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.admin;

import java.math.BigDecimal;
import java.util.Map;
import org.jboss.dmr.ModelNode;
import org.switchyard.admin.Application;
import org.switchyard.admin.Binding;
import org.switchyard.admin.ComponentReference;
import org.switchyard.admin.ComponentService;
import org.switchyard.admin.MessageMetrics;
import org.switchyard.admin.Reference;
import org.switchyard.admin.Service;
import org.switchyard.admin.ServiceOperation;
import org.switchyard.admin.Throttling;
import org.switchyard.admin.Transformer;
import org.switchyard.admin.Validator;
import org.switchyard.config.model.switchyard.ArtifactModel;

public final class ModelNodeCreationUtil {
    public static ModelNode createApplicationNode(Application application) {
        ModelNode applicationNode = new ModelNode();
        ModelNode servicesNode = new ModelNode();
        for (Service service : application.getServices()) {
            servicesNode.add(ModelNodeCreationUtil.createServiceNode(service));
        }
        ModelNode referencesNode = new ModelNode();
        for (Reference reference : application.getReferences()) {
            referencesNode.add(ModelNodeCreationUtil.createReferenceNode(reference));
        }
        ModelNode componentServicesNode = new ModelNode();
        for (ComponentService componentService : application.getComponentServices()) {
            componentServicesNode.add(ModelNodeCreationUtil.createComopnentServiceNode(componentService));
        }
        ModelNode transformersNode = new ModelNode();
        for (Transformer transformer : application.getTransformers()) {
            transformersNode.add(ModelNodeCreationUtil.createTransformerNode(transformer));
        }
        ModelNode artifactsNode = new ModelNode();
        if (application.getConfig().getArtifacts() != null) {
            for (ArtifactModel artifact : application.getConfig().getArtifacts().getArtifacts()) {
                artifactsNode.add(ModelNodeCreationUtil.createArtifactNode(artifact));
            }
        }
        ModelNode validatorsNode = new ModelNode();
        if (application.getValidators() != null) {
            for (Validator validator : application.getValidators()) {
                validatorsNode.add(ModelNodeCreationUtil.createValidatorNode(validator));
            }
        }
        ModelNode propertiesNode = new ModelNode();
        if (application.getProperties() != null) {
            for (Map.Entry property : application.getProperties().entrySet()) {
                ModelNode propertyNode = new ModelNode();
                propertyNode.get("key").set((String)property.getKey());
                propertyNode.get("value").set((String)property.getValue());
                propertiesNode.add(propertyNode);
            }
        }
        applicationNode.get("name").set(application.getName().toString());
        applicationNode.get("services").set(servicesNode);
        applicationNode.get("references").set(referencesNode);
        applicationNode.get("componentServices").set(componentServicesNode);
        applicationNode.get("transformers").set(transformersNode);
        applicationNode.get("artifacts").set(artifactsNode);
        applicationNode.get("validators").set(validatorsNode);
        applicationNode.get("properties").set(propertiesNode);
        return applicationNode;
    }

    public static ModelNode createReferenceNode(Reference reference) {
        ModelNode referenceNode = new ModelNode();
        referenceNode.get("name").set(reference.getName().toString());
        referenceNode.get("application").set(reference.getApplication().getName().toString());
        String interfaceName = reference.getInterface();
        if (interfaceName == null) {
            referenceNode.get("interface");
        } else {
            referenceNode.get("interface").set(interfaceName);
        }
        String promotedReference = reference.getPromotedReference();
        if (promotedReference == null) {
            referenceNode.get("promotedReference");
        } else {
            referenceNode.get("promotedReference").set(promotedReference);
        }
        ModelNode gatewaysNode = new ModelNode();
        for (Binding gateway : reference.getGateways()) {
            gatewaysNode.add(ModelNodeCreationUtil.createGateway(gateway));
        }
        referenceNode.get("gateways").set(gatewaysNode);
        return referenceNode;
    }

    public static ModelNode createServiceNode(Service service) {
        ModelNode serviceNode = new ModelNode();
        serviceNode.get("name").set(service.getName().toString());
        serviceNode.get("application").set(service.getApplication().getName().toString());
        String interfaceName = service.getInterface();
        if (interfaceName == null) {
            serviceNode.get("interface");
        } else {
            serviceNode.get("interface").set(interfaceName);
        }
        ComponentService promotedService = service.getPromotedService();
        if (promotedService == null) {
            serviceNode.get("promotedService");
        } else {
            serviceNode.get("promotedService").set(promotedService.getName().toString());
        }
        ModelNode gatewaysNode = new ModelNode();
        for (Binding gateway : service.getGateways()) {
            gatewaysNode.add(ModelNodeCreationUtil.createGateway(gateway));
        }
        serviceNode.get("gateways").set(gatewaysNode);
        serviceNode.get("throttling").set(ModelNodeCreationUtil.createThrottlingToNode(service.getThrottling()));
        return serviceNode;
    }

    public static ModelNode createComopnentServiceNode(ComponentService service) {
        ModelNode serviceNode = new ModelNode();
        serviceNode.get("name").set(service.getName().toString());
        serviceNode.get("application").set(service.getApplication().getName().toString());
        String interfaceName = service.getInterface();
        if (interfaceName == null) {
            serviceNode.get("interface");
        } else {
            serviceNode.get("interface").set(interfaceName);
        }
        String implementation = service.getImplementation();
        if (implementation == null) {
            serviceNode.get("implementation");
        } else {
            serviceNode.get("implementation").set(implementation);
        }
        String implementationConfiguration = service.getImplementationConfiguration();
        if (implementationConfiguration == null) {
            serviceNode.get("implementationConfiguration");
        } else {
            serviceNode.get("implementationConfiguration").set(implementationConfiguration);
        }
        ModelNode referencesNode = new ModelNode();
        for (ComponentReference reference : service.getReferences()) {
            referencesNode.add(ModelNodeCreationUtil.createComponentReferenceNode(reference));
        }
        serviceNode.get("references").set(referencesNode);
        return serviceNode;
    }

    public static ModelNode createSimpleReferenceNode(Reference reference) {
        ModelNode referenceNode = new ModelNode();
        referenceNode.get("name").set(reference.getName().toString());
        referenceNode.get("application").set(reference.getApplication().getName().toString());
        return referenceNode;
    }

    public static ModelNode createSimpleServiceNode(Service service) {
        ModelNode serviceNode = new ModelNode();
        serviceNode.get("name").set(service.getName().toString());
        serviceNode.get("application").set(service.getApplication().getName().toString());
        return serviceNode;
    }

    public static ModelNode createGateway(Binding binding) {
        ModelNode gatewayNode = new ModelNode();
        if (binding.getName() == null) {
            gatewayNode.get("name");
        } else {
            gatewayNode.get("name").set(binding.getName());
        }
        if (binding.getType() == null) {
            gatewayNode.get("type");
        } else {
            gatewayNode.get("type").set(binding.getType());
        }
        if (binding.getConfiguration() == null) {
            gatewayNode.get("configuration");
        } else {
            gatewayNode.get("configuration").set(binding.getConfiguration());
        }
        gatewayNode.get("state").set(binding.getState().toString());
        return gatewayNode;
    }

    public static ModelNode createComponentReferenceNode(ComponentReference reference) {
        ModelNode referenceNode = new ModelNode();
        if (reference.getName() == null) {
            referenceNode.get("name");
        } else {
            referenceNode.get("name").set(reference.getName().toString());
        }
        if (reference.getInterface() == null) {
            referenceNode.get("interface");
        } else {
            referenceNode.get("interface").set(reference.getInterface());
        }
        return referenceNode;
    }

    public static ModelNode createTransformerNode(Transformer transformation) {
        ModelNode transformationNode = new ModelNode();
        if (transformation.getFrom() == null) {
            transformationNode.get("from");
        } else {
            transformationNode.get("from").set(transformation.getFrom().toString());
        }
        if (transformation.getTo() == null) {
            transformationNode.get("to");
        } else {
            transformationNode.get("to").set(transformation.getTo().toString());
        }
        if (transformation.getType() == null) {
            transformationNode.get("type");
        } else {
            transformationNode.get("type").set(transformation.getType());
        }
        return transformationNode;
    }

    public static ModelNode createArtifactNode(ArtifactModel artifact) {
        ModelNode artifactNode = new ModelNode();
        artifactNode.get("name").set(artifact.getName());
        artifactNode.get("url").set(artifact.getURL());
        return artifactNode;
    }

    public static ModelNode createValidatorNode(Validator validator) {
        ModelNode validatorNode = new ModelNode();
        if (validator.getName() == null) {
            validatorNode.get("name");
        } else {
            validatorNode.get("name").set(validator.getName().toString());
        }
        if (validator.getType() == null) {
            validatorNode.get("type");
        } else {
            validatorNode.get("type").set(validator.getType());
        }
        return validatorNode;
    }

    public static ModelNode addMetricsToNode(ModelNode node, MessageMetrics metrics) {
        node.get("successCount").set(metrics.getSuccessCount());
        node.get("faultCount").set(metrics.getFaultCount());
        node.get("totalCount").set(metrics.getTotalCount());
        node.get("averageTime").set(BigDecimal.valueOf(metrics.getAverageProcessingTime()));
        node.get("minTime").set(metrics.getMinProcessingTime());
        node.get("maxTime").set(metrics.getMaxProcessingTime());
        node.get("totalTime").set(metrics.getTotalProcessingTime());
        return node;
    }

    public static ModelNode createReferenceMetricsNode(Reference reference) {
        ModelNode referenceNode = new ModelNode();
        referenceNode.get("name").set(reference.getName().toString());
        referenceNode.get("application").set(reference.getApplication().getName().toString());
        ModelNodeCreationUtil.addMetricsToNode(referenceNode, reference.getMessageMetrics());
        ModelNode gatewaysNode = new ModelNode();
        for (Binding gateway : reference.getGateways()) {
            ModelNode gatewayNode = new ModelNode();
            gatewayNode.get("name").set(gateway.getName());
            gatewayNode.get("type").set(gateway.getType());
            ModelNodeCreationUtil.addMetricsToNode(gatewayNode, gateway.getMessageMetrics());
            gatewaysNode.add(gatewayNode);
        }
        referenceNode.get("gateways").set(gatewaysNode);
        ModelNode operationsNode = new ModelNode();
        for (ServiceOperation operation : reference.getServiceOperations()) {
            ModelNode operationNode = new ModelNode();
            operationNode.get("name").set(operation.getName());
            ModelNodeCreationUtil.addMetricsToNode(operationNode, operation.getMessageMetrics());
            operationsNode.add(operationNode);
        }
        referenceNode.get("operations").set(operationsNode);
        return referenceNode;
    }

    public static ModelNode createServiceMetricsNode(Service service) {
        ModelNode serviceNode = new ModelNode();
        serviceNode.get("name").set(service.getName().toString());
        serviceNode.get("application").set(service.getApplication().getName().toString());
        ModelNodeCreationUtil.addMetricsToNode(serviceNode, service.getPromotedService().getMessageMetrics());
        ModelNode operationsNode = new ModelNode();
        for (ServiceOperation operation : service.getPromotedService().getServiceOperations()) {
            ModelNode operationNode = new ModelNode();
            operationNode.get("name").set(operation.getName());
            ModelNodeCreationUtil.addMetricsToNode(operationNode, operation.getMessageMetrics());
            operationsNode.add(operationNode);
        }
        serviceNode.get("operations").set(operationsNode);
        ModelNode referencesNode = new ModelNode();
        for (ComponentReference reference : service.getPromotedService().getReferences()) {
            ModelNode referenceNode = new ModelNode();
            referenceNode.get("name").set(reference.getName().toString());
            ModelNodeCreationUtil.addMetricsToNode(referenceNode, reference.getMessageMetrics());
            referencesNode.add(referenceNode);
        }
        serviceNode.get("references").set(referencesNode);
        ModelNode gatewaysNode = new ModelNode();
        for (Binding gateway : service.getGateways()) {
            ModelNode gatewayNode = new ModelNode();
            gatewayNode.get("name").set(gateway.getName());
            gatewayNode.get("type").set(gateway.getType());
            ModelNodeCreationUtil.addMetricsToNode(gatewayNode, gateway.getMessageMetrics());
            gatewaysNode.add(gatewayNode);
        }
        serviceNode.get("gateways").set(gatewaysNode);
        return serviceNode;
    }

    public static ModelNode createComponentServiceMetricsNode(ComponentService componentService) {
        ModelNode serviceNode = new ModelNode();
        serviceNode.get("name").set(componentService.getName().toString());
        serviceNode.get("application").set(componentService.getApplication().getName().toString());
        ModelNodeCreationUtil.addMetricsToNode(serviceNode, componentService.getMessageMetrics());
        ModelNode operationsNode = new ModelNode();
        for (ServiceOperation operation : componentService.getServiceOperations()) {
            ModelNode operationNode = new ModelNode();
            operationNode.get("name").set(operation.getName());
            ModelNodeCreationUtil.addMetricsToNode(operationNode, operation.getMessageMetrics());
            operationsNode.add(operationNode);
        }
        serviceNode.get("operations").set(operationsNode);
        ModelNode referencesNode = new ModelNode();
        for (ComponentReference reference : componentService.getReferences()) {
            ModelNode referenceNode = new ModelNode();
            referenceNode.get("name").set(reference.getName().toString());
            ModelNodeCreationUtil.addMetricsToNode(referenceNode, reference.getMessageMetrics());
            referencesNode.add(referenceNode);
        }
        serviceNode.get("references").set(referencesNode);
        return serviceNode;
    }

    public static ModelNode createThrottlingToNode(Throttling throttling) {
        ModelNode node = new ModelNode();
        if (throttling == null) {
            return node;
        }
        node.get("enabled").set(throttling.isEnabled());
        node.get("maxRequests").set(throttling.getMaxRequests());
        node.get("timePeriod").set(throttling.getTimePeriod());
        return node;
    }

    private ModelNodeCreationUtil() {
    }
}

