/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;

public class SerializableUtils {
    public static Object cloneSerializable(Object obj) {
        Object ret = null;
        try {
            ObjectInputStream ois;
            block4: {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(16384);
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(obj);
                oos.close();
                ByteArrayInputStream bis = new ByteArrayInputStream(baos.toByteArray());
                ois = new ObjectInputStream(bis);
                try {
                    ret = ois.readObject();
                }
                catch (ClassNotFoundException cnfe) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError();
                }
            }
            ois.close();
        }
        catch (IOException ioex) {
            throw new RuntimeException("Unable to clone object: " + obj);
        }
        return ret;
    }

    public static byte[] toBytes(Object obj) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(16384);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
        }
        catch (IOException e) {
            throw new RuntimeException("Error serializing object: " + obj.getClass() + ".", e);
        }
        return bos.toByteArray();
    }

    public static Object toObject(InputStream binaryStream, final ClassLoader cl) {
        try {
            ObjectInputStream ois = new ObjectInputStream(binaryStream){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    String name = desc.getName();
                    try {
                        return Class.forName(name, false, cl);
                    }
                    catch (ClassNotFoundException ex) {
                        return super.resolveClass(desc);
                    }
                }
            };
            return ois.readObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object toObject(byte[] arr, ClassLoader cl) {
        ByteArrayInputStream bis = new ByteArrayInputStream(arr);
        return SerializableUtils.toObject(bis, cl);
    }
}

