/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.standalone;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jboss.logging.Logger;
import org.switchyard.ServiceDomain;
import org.switchyard.deploy.Activator;
import org.switchyard.deploy.ActivatorLoader;
import org.switchyard.deploy.BaseDeployMessages;
import org.switchyard.deploy.ServiceDomainManager;
import org.switchyard.deploy.internal.Deployment;

public class SwitchYard {
    private static Logger _logger = Logger.getLogger(SwitchYard.class);
    private List<Activator> _activatorList;
    private ServiceDomain _domain;
    private Deployment _deployment;

    public SwitchYard(InputStream config) throws IOException {
        this._deployment = new Deployment(config);
        this._domain = new ServiceDomainManager().createDomain(this._deployment.getConfig().getQName(), this._deployment.getConfig());
        this._activatorList = ActivatorLoader.createActivators(this._domain);
    }

    public void start() {
        _logger.debug((Object)("Starting SwitchYard application '" + this._deployment.getConfig().getQName() + "'."));
        this._deployment.init(this._domain, this._activatorList);
        this._deployment.start();
        _logger.debug((Object)("SwitchYard application '" + this._deployment.getConfig().getQName() + "' started."));
    }

    public void stop() {
        _logger.debug((Object)("Stopping SwitchYard application '" + this._deployment.getConfig().getQName() + "'."));
        this._deployment.stop();
        _logger.debug((Object)("SwitchYard application '" + this._deployment.getConfig().getQName() + "' stopped."));
    }

    public List<Activator> getActivatorList() {
        return this._activatorList;
    }

    public void setActivatorList(List<Activator> activators) {
        this._activatorList = activators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        SwitchYard switchyard;
        InputStream configStream;
        if (args.length == 0) {
            configStream = SwitchYard.class.getResourceAsStream("/META-INF/switchyard.xml");
            if (configStream == null) {
                System.out.println(BaseDeployMessages.MESSAGES.usagePath(SwitchYard.class.getName()));
                System.exit(1);
            }
        } else {
            File configFile = new File(args[0]);
            if (!configFile.isFile()) {
                System.out.println(BaseDeployMessages.MESSAGES.notValidConfigFile(args[0]));
                System.exit(1);
            }
            configStream = new FileInputStream(configFile);
        }
        try {
            switchyard = new SwitchYard(configStream);
        }
        finally {
            configStream.close();
        }
        switchyard.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                switchyard.stop();
                switchyard.notify();
            }
        });
        switchyard.wait();
        System.exit(0);
    }
}

