/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.il;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.NSContext;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class OMUtils {
    public static OMElement getFirstChildWithName(OMElement parent, String name) {
        if (parent == null) {
            throw new IllegalArgumentException("null parent");
        }
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        Iterator it = parent.getChildElements();
        while (it.hasNext()) {
            OMElement e = (OMElement)it.next();
            if (!name.equals(e.getQName().getLocalPart())) continue;
            return e;
        }
        return null;
    }

    public static Element toDOM(OMElement element) {
        return OMUtils.toDOM(element, DOMUtils.newDocument());
    }

    public static Element toDOM(OMElement element, Document doc) {
        return OMUtils.toDOM(element, doc, true);
    }

    public static Element toDOM(OMElement element, Document doc, boolean deepNS) {
        Iterator i;
        Element domElement = doc.createElementNS(element.getQName().getNamespaceURI(), element.getQName().getLocalPart());
        if (deepNS) {
            NSContext nscontext = new NSContext();
            OMUtils.buildNScontext(nscontext, element);
            DOMUtils.injectNamespaces((Element)domElement, (NSContext)nscontext);
        } else if (element.getAllDeclaredNamespaces() != null) {
            i = element.getAllDeclaredNamespaces();
            while (i.hasNext()) {
                OMNamespace omns = (OMNamespace)i.next();
                if (omns.getPrefix().equals("")) {
                    domElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", omns.getNamespaceURI() == null ? "" : omns.getNamespaceURI());
                    continue;
                }
                domElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + omns.getPrefix(), omns.getNamespaceURI());
            }
        }
        i = element.getAllAttributes();
        while (i.hasNext()) {
            OMNamespace attrValNs;
            OMAttribute attr = (OMAttribute)i.next();
            Attr newAttr = attr.getNamespace() != null ? doc.createAttributeNS(attr.getNamespace().getNamespaceURI(), attr.getLocalName()) : doc.createAttributeNS(null, attr.getLocalName());
            newAttr.appendChild(doc.createTextNode(attr.getAttributeValue()));
            domElement.setAttributeNodeNS(newAttr);
            int colonIdx = attr.getAttributeValue().indexOf(":");
            if (colonIdx <= 0 || (attrValNs = element.findNamespaceURI(attr.getAttributeValue().substring(0, colonIdx))) == null) continue;
            domElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + attrValNs.getPrefix(), attrValNs.getNamespaceURI());
        }
        i = element.getChildren();
        while (i.hasNext()) {
            OMNode omn = (OMNode)i.next();
            switch (omn.getType()) {
                case 12: {
                    domElement.appendChild(doc.createCDATASection(((OMText)omn).getText()));
                    break;
                }
                case 4: {
                    domElement.appendChild(doc.createTextNode(((OMText)omn).getText()));
                    break;
                }
                case 1: {
                    domElement.appendChild(OMUtils.toDOM((OMElement)omn, doc, false));
                }
            }
        }
        return domElement;
    }

    private static void buildNScontext(NSContext nscontext, OMElement element) {
        if (element == null) {
            return;
        }
        if (element.getParent() instanceof OMElement) {
            OMUtils.buildNScontext(nscontext, (OMElement)element.getParent());
        }
        if (element.getAllDeclaredNamespaces() != null) {
            Iterator i = element.getAllDeclaredNamespaces();
            while (i.hasNext()) {
                OMNamespace omn = (OMNamespace)i.next();
                nscontext.register(omn.getPrefix(), omn.getNamespaceURI());
            }
        }
        if (element.getDefaultNamespace() != null) {
            nscontext.register("", element.getDefaultNamespace().getNamespaceURI());
        }
    }

    public static OMElement toOM(Element src, OMFactory omf) {
        return OMUtils.toOM(src, omf, null);
    }

    public static OMElement toOM(Element src, OMFactory omf, OMContainer parent) {
        OMElement omElement;
        OMElement oMElement = omElement = parent == null ? omf.createOMElement(src.getLocalName(), null) : omf.createOMElement(src.getLocalName(), null, parent);
        if (src.getNamespaceURI() != null) {
            if (src.getPrefix() != null) {
                omElement.setNamespace(omf.createOMNamespace(src.getNamespaceURI(), src.getPrefix()));
            } else {
                omElement.declareDefaultNamespace(src.getNamespaceURI());
            }
        }
        if (parent == null) {
            NSContext nscontext = DOMUtils.getMyNSContext((Element)src);
            OMUtils.injectNamespaces(omElement, nscontext.toMap());
        } else {
            Map nss = DOMUtils.getMyNamespaces((Element)src);
            OMUtils.injectNamespaces(omElement, nss);
        }
        NamedNodeMap attrs = src.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getLocalName().equals("xmlns") || attr.getNamespaceURI() != null && attr.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) continue;
            OMNamespace attrOmNs = null;
            String attrNs = attr.getNamespaceURI();
            String attrPrefix = attr.getPrefix();
            if (attrNs != null) {
                attrOmNs = omElement.findNamespace(attrNs, null);
            }
            if (attrOmNs == null && attrPrefix != null) {
                attrOmNs = omElement.findNamespace(null, attrPrefix);
            }
            omElement.addAttribute(attr.getLocalName(), attr.getValue(), attrOmNs);
        }
        NodeList children = src.getChildNodes();
        block6: for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            switch (n.getNodeType()) {
                case 4: {
                    omElement.addChild((OMNode)omf.createOMText(((CDATASection)n).getTextContent(), 12));
                    continue block6;
                }
                case 3: {
                    omElement.addChild((OMNode)omf.createOMText(((Text)n).getTextContent(), 4));
                    continue block6;
                }
                case 1: {
                    OMUtils.toOM((Element)n, omf, (OMContainer)omElement);
                }
            }
        }
        return omElement;
    }

    private static void injectNamespaces(OMElement omElement, Map<String, String> nscontext) {
        for (String prefix : nscontext.keySet()) {
            String uri = nscontext.get(prefix);
            if (prefix.equals("")) {
                omElement.declareDefaultNamespace(uri);
                continue;
            }
            omElement.declareNamespace(uri, prefix);
        }
    }

    public static QName getTextAsQName(OMElement elmt) {
        QName qname = elmt.getTextAsQName();
        if (qname == null || qname.getNamespaceURI().length() == 0) {
            int colonIdx = elmt.getText().indexOf(":");
            String localpart = elmt.getText().substring(colonIdx + 1, elmt.getText().length());
            String prefix = elmt.getText().substring(0, colonIdx);
            String ns = elmt.findNamespaceURI(prefix).getNamespaceURI();
            qname = new QName(ns, localpart, prefix);
        }
        return qname;
    }

    public static OMElement toOM(Source inputSource) throws IOException {
        Document doc = DOMUtils.sourceToDOM((Source)inputSource);
        return OMUtils.toOM(doc.getDocumentElement(), OMAbstractFactory.getOMFactory());
    }
}

