/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edisax;

import org.milyn.edisax.model.internal.Edimap;
import org.milyn.edisax.model.internal.MappingNode;
import org.xml.sax.SAXException;

public class EDIParseException
extends SAXException {
    private static final long serialVersionUID = 1L;
    private MappingNode errorNode;
    private int segmentNumber;
    private String[] segmentline;

    public EDIParseException(String message) {
        super(message);
    }

    public EDIParseException(String message, Exception cause) {
        super(message, cause);
    }

    public EDIParseException(Edimap mappingModel, String message) {
        super(EDIParseException.getMessagePrefix(mappingModel) + "  " + message);
    }

    public EDIParseException(Edimap mappingModel, String message, Exception cause) {
        super(EDIParseException.getMessagePrefix(mappingModel) + "  " + message, cause);
    }

    public EDIParseException(String message, Exception cause, MappingNode mappingNode, int segmentNumber, String[] segmentLine) {
        super(message, cause);
        this.errorNode = mappingNode;
        this.segmentNumber = segmentNumber;
        this.segmentline = segmentLine;
    }

    public EDIParseException(Edimap mappingModel, String message, MappingNode mappingNode, int segmentNumber, String[] segmentLine) {
        super(EDIParseException.getMessagePrefix(mappingModel) + "  " + message);
        this.errorNode = mappingNode;
        this.segmentNumber = segmentNumber;
        this.segmentline = segmentLine;
    }

    public EDIParseException(Edimap mappingModel, String message, Exception cause, MappingNode mappingNode, int segmentNumber, String[] segmentLine) {
        super(EDIParseException.getMessagePrefix(mappingModel) + "  " + message, cause);
        this.errorNode = mappingNode;
        this.segmentNumber = segmentNumber;
        this.segmentline = segmentLine;
    }

    private static String getMessagePrefix(Edimap mappingModel) {
        return "EDI message processing failed [" + mappingModel.getDescription().getName() + "][" + mappingModel.getDescription().getVersion() + "].";
    }

    public MappingNode getErrorNode() {
        return this.errorNode;
    }

    public int getSegmentNumber() {
        return this.segmentNumber;
    }

    public String[] getSegmentline() {
        return this.segmentline;
    }
}

