/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.memdao;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.common.InstanceFilter;
import org.apache.ode.bpel.memdao.DaoBaseImpl;
import org.apache.ode.dao.bpel.BpelDAOConnection;
import org.apache.ode.dao.bpel.ProcessInstanceDAO;
import org.apache.ode.dao.bpel.ProcessManagementDAO;

public class ProcessManagementDaoImpl
extends DaoBaseImpl
implements ProcessManagementDAO {
    public Object[] findFailedCountAndLastFailedDateForProcessId(BpelDAOConnection conn, String status, String processId) {
        Date lastFailureDt = null;
        int failureInstances = 0;
        InstanceFilter instanceFilter = new InstanceFilter("status=" + status + " pid=" + processId);
        for (ProcessInstanceDAO instance : conn.instanceQuery(instanceFilter)) {
            int count = instance.getActivityFailureCount();
            if (count <= 0) continue;
            ++failureInstances;
            Date failureDt = instance.getActivityFailureDateTime();
            if (lastFailureDt != null && !lastFailureDt.before(failureDt)) continue;
            lastFailureDt = failureDt;
        }
        return new Object[]{failureInstances, lastFailureDt};
    }

    public void prefetchActivityFailureCounts(Collection<ProcessInstanceDAO> instances) {
    }

    public int countInstancesByPidAndString(BpelDAOConnection conn, QName pid, String status) {
        InstanceFilter instanceFilter = new InstanceFilter("status=" + status + " pid=" + pid);
        return conn.instanceQuery(instanceFilter).size();
    }

    public Map<ProcessManagementDAO.InstanceSummaryKey, Long> countInstancesSummary(Set<String> pids) {
        return new HashMap<ProcessManagementDAO.InstanceSummaryKey, Long>();
    }

    public Map<String, ProcessManagementDAO.FailedSummaryValue> findFailedCountAndLastFailedDateForProcessIds(Set<String> pids) {
        return new HashMap<String, ProcessManagementDAO.FailedSummaryValue>();
    }
}

