/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.bus.camel;

import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Message;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.direct.DirectEndpoint;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.model.ModelCamelContext;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangePattern;
import org.switchyard.ExchangePhase;
import org.switchyard.ServiceReference;
import org.switchyard.bus.camel.BusMessages;
import org.switchyard.bus.camel.CamelExchange;
import org.switchyard.bus.camel.CamelMessage;
import org.switchyard.label.BehaviorLabel;
import org.switchyard.metadata.qos.Throttling;
import org.switchyard.spi.Dispatcher;

public class ExchangeDispatcher
implements Dispatcher {
    private final ModelCamelContext _context;
    private ServiceReference _reference;
    private ProducerTemplate _producer;

    public ExchangeDispatcher(ModelCamelContext context, ServiceReference reference) {
        this._context = context;
        this._reference = reference;
        this._producer = context.createProducerTemplate();
    }

    public ServiceReference getServiceReference() {
        return this._reference;
    }

    public Exchange createExchange(ExchangeHandler replyHandler, ExchangePattern pattern) {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this._context, this.translate(pattern));
        exchange.setIn((Message)new CamelMessage((org.apache.camel.Exchange)exchange));
        return new CamelExchange(this, (org.apache.camel.Exchange)exchange, replyHandler);
    }

    private org.apache.camel.ExchangePattern translate(ExchangePattern pattern) {
        return ExchangePattern.IN_OUT == pattern ? org.apache.camel.ExchangePattern.InOut : org.apache.camel.ExchangePattern.InOnly;
    }

    public void dispatch(Exchange exchange) {
        String uri;
        DirectEndpoint ep;
        if (!CamelExchange.class.isInstance(exchange)) {
            throw BusMessages.MESSAGES.onlyCamelExchanges();
        }
        CamelExchange camelEx = (CamelExchange)exchange;
        if (!exchange.getPhase().equals((Object)ExchangePhase.IN)) {
            return;
        }
        Throttling throttling = this._reference.getServiceMetadata().getThrottling();
        if (throttling != null && throttling.getMaxRequests() > 0) {
            exchange.getMessage().getContext().setProperty("org.switchyard.qos.throttling.maxRequests", (Object)throttling.getMaxRequests()).addLabels(new String[]{BehaviorLabel.TRANSIENT.label()});
        }
        if ((ep = (DirectEndpoint)this._context.getEndpoint(uri = "direct:" + exchange.getConsumer().getName(), DirectEndpoint.class)).getConsumer() == null) {
            throw BusMessages.MESSAGES.consumerForinternalCamelRouteNotFound(uri);
        }
        this._producer.send((Endpoint)ep, camelEx.getExchange());
    }
}

