/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.wsdl.xml.WSDLLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.ResourceFinder;
import org.xml.sax.InputSource;

public class WSDLLocatorImpl
implements WSDLLocator {
    private static final Log __log = LogFactory.getLog(WSDLLocatorImpl.class);
    private ResourceFinder _resourceFinder;
    private URI _base;
    private String _latest;

    public WSDLLocatorImpl(ResourceFinder resourceFinder, URI base) {
        this._resourceFinder = resourceFinder;
        this._base = base;
    }

    public InputSource getBaseInputSource() {
        try {
            InputSource is = new InputSource();
            is.setByteStream(this._resourceFinder.openResource(this._base));
            is.setSystemId(this._base.toString());
            return is;
        }
        catch (MalformedURLException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public InputSource getImportInputSource(String parent, String imprt) {
        URI uri;
        try {
            uri = parent == null ? this._base.resolve(imprt) : new URI(parent).resolve(imprt);
        }
        catch (URISyntaxException e1) {
            __log.error((Object)("URI syntax error: " + parent));
            return null;
        }
        __log.debug((Object)("getImportInputSource: parent=" + parent + ", imprt=" + imprt + ", uri=" + uri));
        InputSource is = new InputSource();
        try {
            is.setByteStream(this._resourceFinder.openResource(uri));
        }
        catch (Exception e) {
            return null;
        }
        is.setSystemId(uri.toString());
        this._latest = uri.toString();
        return is;
    }

    public String getBaseURI() {
        return this._base.toString();
    }

    public String getLatestImportURI() {
        return this._latest;
    }

    public void close() {
        this._resourceFinder = null;
    }
}

