/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.util.Collection;
import java.util.Map;

public class CollectionUtils {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Class[] EMPTY_CLASS_ARRAY = new Class[0];

    public static <T> Collection<T> makeCollection(Class<? extends Collection> type, T[] elements) {
        if (elements == null) {
            return null;
        }
        try {
            Collection c = type.newInstance();
            for (int i = 0; i < elements.length; ++i) {
                c.add(elements[i]);
            }
            return c;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Invalid arguments.", ex);
        }
    }

    public static boolean equals(Map m1, Map m2) {
        if (m2 == m1) {
            return true;
        }
        if (m1 == null) {
            return false;
        }
        if (m2 == null) {
            return false;
        }
        if (m2.size() != m1.size()) {
            return false;
        }
        try {
            for (Map.Entry e : m1.entrySet()) {
                Object key = e.getKey();
                Object value = e.getValue();
                if (!(value == null ? m2.get(key) != null || !m2.containsKey(key) : !value.equals(m2.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        return true;
    }
}

