/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.il.dbutil;

import javax.resource.spi.ConnectionManager;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.connector.outbound.GenericConnectionManager;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.LocalTransactions;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PoolingSupport;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.SinglePool;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.TransactionSupport;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectionTracker;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectionTrackingCoordinator;
import org.apache.geronimo.transaction.manager.RecoverableTransactionManager;
import org.apache.ode.il.config.OdeConfigProperties;
import org.apache.ode.il.dbutil.DatabaseConfigException;
import org.apache.ode.il.dbutil.Messages;
import org.tranql.connector.jdbc.JDBCDriverMCF;

public class DatabaseConnectionManager {
    private static final long serialVersionUID = 1L;
    private static final Log __log = LogFactory.getLog(DatabaseConnectionManager.class);
    private static final Messages __msgs = (Messages)Messages.getMessages(Messages.class);
    private static final int CONNECTION_MAX_WAIT_MILLIS = 30000;
    private static final int CONNECTION_MAX_IDLE_MINUTES = 5;
    private GenericConnectionManager _connectionManager;
    private TransactionManager _txm = null;
    private String _url = null;
    private OdeConfigProperties _odeConfig = null;
    private DataSource _dataSource = null;

    public DatabaseConnectionManager(TransactionManager txm, OdeConfigProperties odeConfig) {
        this._txm = txm;
        this._odeConfig = odeConfig;
    }

    public void init(String url, String driverClass, String username, String password) throws DatabaseConfigException {
        __log.debug((Object)("Creating connection pool for " + url + " with driver " + driverClass));
        if (!(this._txm instanceof RecoverableTransactionManager)) {
            throw new RuntimeException("TransactionManager is not recoverable.");
        }
        this._url = url;
        TransactionSupport transactionSupport = LocalTransactions.INSTANCE;
        ConnectionTrackingCoordinator connectionTracker = new ConnectionTrackingCoordinator();
        SinglePool poolingSupport = new SinglePool(this._odeConfig.getPoolMaxSize(), this._odeConfig.getPoolMinSize(), 30000, 5, true, false, false);
        this._connectionManager = new GenericConnectionManager(transactionSupport, (PoolingSupport)poolingSupport, null, (ConnectionTracker)connectionTracker, (RecoverableTransactionManager)this._txm, this.getClass().getName(), this.getClass().getClassLoader());
        JDBCDriverMCF mcf = new JDBCDriverMCF();
        try {
            mcf.setDriver(driverClass);
            mcf.setConnectionURL(url);
            if (username != null) {
                mcf.setUserName(username);
            }
            if (password != null) {
                mcf.setPassword(password);
            }
            this._connectionManager.doStart();
            this._dataSource = (DataSource)mcf.createConnectionFactory((ConnectionManager)this._connectionManager);
        }
        catch (Exception ex) {
            String errmsg = __msgs.msgOdeDbPoolStartupFailed(url);
            __log.error((Object)errmsg, (Throwable)ex);
            throw new DatabaseConfigException(errmsg, ex);
        }
    }

    public void shutdown() throws DatabaseConfigException {
        try {
            this._connectionManager.doStop();
        }
        catch (Exception ex) {
            String errmsg = __msgs.msgOdeDbPoolStartupFailed(this._url);
            __log.error((Object)errmsg, (Throwable)ex);
            throw new DatabaseConfigException(errmsg, ex);
        }
    }

    public DataSource getDataSource() {
        return this._dataSource;
    }
}

