/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap.endpoint;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.ws.WebServiceFeature;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.jboss.logging.Logger;
import org.switchyard.ServiceDomain;
import org.switchyard.common.type.Classes;
import org.switchyard.component.common.Endpoint;
import org.switchyard.component.soap.AddressingInterceptor;
import org.switchyard.component.soap.InboundHandler;
import org.switchyard.component.soap.WebServicePublishException;
import org.switchyard.component.soap.config.model.SOAPBindingModel;
import org.switchyard.component.soap.endpoint.AbstractEndpointPublisher;
import org.switchyard.component.soap.endpoint.CXFJettyEndpoint;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CXFJettyEndpointPublisher
extends AbstractEndpointPublisher {
    private static final String HTTP_SCHEME = "http";
    private static final Logger LOGGER = Logger.getLogger(CXFJettyEndpointPublisher.class);

    @Override
    public synchronized Endpoint publish(ServiceDomain domain, SOAPBindingModel config, String bindingId, InboundHandler handler, WebServiceFeature ... features) {
        CXFJettyEndpoint wsEndpoint = null;
        try {
            this.initialize(config);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("javax.xml.ws.wsdl.service", config.getPort().getServiceQName());
            properties.put("javax.xml.ws.wsdl.port", config.getPort().getPortQName());
            properties.put("javax.xml.ws.wsdl.description", this.getWsdlLocation());
            String publishUrl = "http://" + config.getSocketAddr().getHost() + ":" + config.getSocketAddr().getPort() + "/" + this.getContextPath();
            Object configFile = null;
            wsEndpoint = new CXFJettyEndpoint(bindingId, config, handler, (Interceptor<? extends Message>)new AddressingInterceptor(), features);
            if (config.getEndpointConfig() != null) {
                String endpointFile = config.getEndpointConfig().getConfigFile();
                wsEndpoint = this.parseJaxWSConfig(endpointFile, wsEndpoint);
            }
            wsEndpoint.getEndpoint().setWsdlURL(this.getWsdlLocation());
            wsEndpoint.getEndpoint().setServiceName(config.getPort().getServiceQName());
            wsEndpoint.publish(publishUrl);
        }
        catch (MalformedURLException e) {
            throw new WebServicePublishException(e);
        }
        return wsEndpoint;
    }

    private CXFJettyEndpoint parseJaxWSConfig(String fileName, CXFJettyEndpoint endpoint) {
        HashMap<String, String> props = new HashMap<String, String>();
        ArrayList handlerList = new ArrayList();
        try {
            URL url = Classes.getResource((String)fileName);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(url.openStream());
            doc.getDocumentElement().normalize();
            NodeList endpointConfigs = doc.getElementsByTagName("endpoint-config");
            for (int temp = 0; temp < endpointConfigs.getLength(); ++temp) {
                Node node = endpointConfigs.item(temp);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                NodeList propertyNodeList = element.getElementsByTagName("property");
                for (int count = 0; count < propertyNodeList.getLength(); ++count) {
                    Node propNode = propertyNodeList.item(count);
                    String propertyName = element.getElementsByTagName("property-name").item(0).getTextContent();
                    String propertyValue = element.getElementsByTagName("property-value").item(0).getTextContent();
                    props.put(propertyName, propertyValue);
                }
            }
        }
        catch (IOException ioe) {
            LOGGER.warn((Object)("failed to parse " + fileName + ", ignoring: " + ioe.getMessage()));
        }
        catch (ParserConfigurationException pce) {
            LOGGER.warn((Object)("failed to parse " + fileName + ", ignoring: " + pce.getMessage()));
        }
        catch (SAXException se) {
            LOGGER.warn((Object)("failed to parse " + fileName + ", ignoring: " + se.getMessage()));
        }
        endpoint.getEndpoint().setProperties(props);
        return endpoint;
    }
}

