/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.http;

import java.nio.charset.Charset;

public class ContentType {
    private static final String DEFAULT_MIME_TYPE = "text/plain";
    private static final String CHARSET = "charset";
    private String _mimeType;
    private String _charset;

    public ContentType() {
        this._mimeType = DEFAULT_MIME_TYPE;
        this._charset = Charset.defaultCharset().name();
    }

    public ContentType(String contentType) {
        if (contentType == null) {
            this._mimeType = DEFAULT_MIME_TYPE;
            this._charset = Charset.defaultCharset().name();
        } else {
            String[] types = contentType.split(";");
            this._mimeType = types[0];
            for (int i = 1; i < types.length; ++i) {
                if (!types[i].contains(CHARSET)) continue;
                this._charset = types[i].split("=")[1];
            }
        }
    }

    public String getMimeType() {
        return this._mimeType;
    }

    public void setMimeType(String mimeType) {
        this._mimeType = mimeType;
    }

    public String getCharset() {
        return this._charset;
    }

    public void setCharset(String charset) {
        this._charset = charset;
    }

    public String toString() {
        return this._mimeType + ";" + CHARSET + "=" + this._charset;
    }
}

