/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.config.model.domain.v1;

import java.util.Set;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.type.Classes;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.BaseNamedModel;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.domain.SecuritiesModel;
import org.switchyard.config.model.domain.SecurityModel;
import org.switchyard.config.model.property.PropertiesModel;

public class V1SecurityModel
extends BaseNamedModel
implements SecurityModel {
    private static final String CALLBACK_HANDLER = "callbackHandler";
    private static final String ROLES_ALLOWED = "rolesAllowed";
    private static final String RUN_AS = "runAs";
    private static final String SECURITY_DOMAIN = "securityDomain";
    private PropertiesModel _properties;

    public V1SecurityModel(String namespace) {
        super(namespace, "security");
        this.setModelChildrenOrder("properties");
    }

    public V1SecurityModel(Configuration config, Descriptor desc) {
        super(config, desc);
        this.setModelChildrenOrder("properties");
    }

    @Override
    public SecuritiesModel getSecurities() {
        return (SecuritiesModel)this.getModelParent();
    }

    @Override
    public Class<?> getCallbackHandler(ClassLoader loader) {
        String c = Strings.trimToNull((String)this.getModelAttribute(CALLBACK_HANDLER));
        return c != null ? Classes.forName((String)c, (ClassLoader[])new ClassLoader[]{loader}) : null;
    }

    @Override
    public SecurityModel setCallbackHandler(Class<?> clazz) {
        String c = clazz != null ? clazz.getName() : null;
        this.setModelAttribute(CALLBACK_HANDLER, c);
        return this;
    }

    @Override
    public Set<String> getRolesAllowed() {
        String ra = this.getModelAttribute(ROLES_ALLOWED);
        return Strings.uniqueSplitTrimToNull((String)ra, (String)",");
    }

    @Override
    public SecurityModel setRolesAllowed(Set<String> rolesAllowed) {
        String[] ra = rolesAllowed != null ? rolesAllowed.toArray(new String[rolesAllowed.size()]) : null;
        this.setModelAttribute(ROLES_ALLOWED, Strings.concat((String)",", (String[])ra));
        return this;
    }

    @Override
    public String getRunAs() {
        String runAs = this.getModelAttribute(RUN_AS);
        return Strings.trimToNull((String)runAs);
    }

    @Override
    public SecurityModel setRunAs(String runAs) {
        this.setModelAttribute(RUN_AS, runAs);
        return this;
    }

    @Override
    public synchronized PropertiesModel getProperties() {
        if (this._properties == null) {
            this._properties = (PropertiesModel)this.getFirstChildModel("properties");
        }
        return this._properties;
    }

    @Override
    public SecurityModel setProperties(PropertiesModel properties) {
        this.setChildModel(properties);
        this._properties = properties;
        return this;
    }

    @Override
    public String getSecurityDomain() {
        String securityDomain = this.getModelAttribute(SECURITY_DOMAIN);
        return Strings.trimToNull((String)securityDomain);
    }

    @Override
    public SecurityModel setSecurityDomain(String securityDomainName) {
        this.setModelAttribute(SECURITY_DOMAIN, securityDomainName);
        return this;
    }
}

