/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.json;

import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.milyn.GenericReaderConfigurator;
import org.milyn.ReaderConfigurator;
import org.milyn.assertion.AssertArgument;
import org.milyn.cdr.Parameter;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.json.JSONReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONReaderConfigurator
implements ReaderConfigurator {
    private String rootName = "json";
    private String arrayElementName = "element";
    private String keyWhitspaceReplacement;
    private String keyPrefixOnNumeric;
    private String illegalElementNameCharReplacement;
    private String nullValueReplacement = "";
    private Charset encoding = Charset.forName("UTF-8");
    private Map<String, String> keyMap;
    private String targetProfile;

    public JSONReaderConfigurator setRootName(String rootName) {
        AssertArgument.isNotNull(rootName, "rootName");
        this.rootName = rootName;
        return this;
    }

    public JSONReaderConfigurator setArrayElementName(String arrayElementName) {
        AssertArgument.isNotNull(arrayElementName, "arrayElementName");
        this.arrayElementName = arrayElementName;
        return this;
    }

    public JSONReaderConfigurator setKeyWhitspaceReplacement(String keyWhitspaceReplacement) {
        AssertArgument.isNotNull(keyWhitspaceReplacement, "keyWhitspaceReplacement");
        this.keyWhitspaceReplacement = keyWhitspaceReplacement;
        return this;
    }

    public JSONReaderConfigurator setKeyPrefixOnNumeric(String keyPrefixOnNumeric) {
        AssertArgument.isNotNull(keyPrefixOnNumeric, "keyPrefixOnNumeric");
        this.keyPrefixOnNumeric = keyPrefixOnNumeric;
        return this;
    }

    public JSONReaderConfigurator setIllegalElementNameCharReplacement(String illegalElementNameCharReplacement) {
        AssertArgument.isNotNull(illegalElementNameCharReplacement, "illegalElementNameCharReplacement");
        this.illegalElementNameCharReplacement = illegalElementNameCharReplacement;
        return this;
    }

    public JSONReaderConfigurator setNullValueReplacement(String nullValueReplacement) {
        AssertArgument.isNotNull(nullValueReplacement, "nullValueReplacement");
        this.nullValueReplacement = nullValueReplacement;
        return this;
    }

    public JSONReaderConfigurator setEncoding(Charset encoding) {
        AssertArgument.isNotNull(encoding, "encoding");
        this.encoding = encoding;
        return this;
    }

    public JSONReaderConfigurator setKeyMap(Map<String, String> keyMap) {
        AssertArgument.isNotNull(keyMap, "keyMap");
        this.keyMap = keyMap;
        return this;
    }

    public JSONReaderConfigurator setTargetProfile(String targetProfile) {
        AssertArgument.isNotNullAndNotEmpty(targetProfile, "targetProfile");
        this.targetProfile = targetProfile;
        return this;
    }

    @Override
    public List<SmooksResourceConfiguration> toConfig() {
        GenericReaderConfigurator configurator = new GenericReaderConfigurator(JSONReader.class);
        configurator.getParameters().setProperty("rootName", this.rootName);
        configurator.getParameters().setProperty("arrayElementName", this.arrayElementName);
        if (this.keyWhitspaceReplacement != null) {
            configurator.getParameters().setProperty("keyWhitspaceReplacement", this.keyWhitspaceReplacement);
        }
        if (this.keyPrefixOnNumeric != null) {
            configurator.getParameters().setProperty("keyPrefixOnNumeric", this.keyPrefixOnNumeric);
        }
        if (this.illegalElementNameCharReplacement != null) {
            configurator.getParameters().setProperty("illegalElementNameCharReplacement", this.illegalElementNameCharReplacement);
        }
        configurator.getParameters().setProperty("nullValueReplacement", this.nullValueReplacement);
        configurator.getParameters().setProperty("encoding", this.encoding.name());
        List<SmooksResourceConfiguration> configList = configurator.toConfig();
        SmooksResourceConfiguration config = configList.get(0);
        if (this.keyMap != null) {
            Parameter keyMapParam = new Parameter("keyMap", this.keyMap);
            config.setParameter(keyMapParam);
        }
        config.setTargetProfile(this.targetProfile);
        return configList;
    }
}

