/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.scribe.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.milyn.assertion.AssertArgument;

public class EntityMethod {
    private final Method method;
    private final boolean returnsEntity;

    public EntityMethod(Method method, boolean returnsEntity) {
        AssertArgument.isNotNull(method, "method");
        this.method = method;
        this.returnsEntity = returnsEntity;
    }

    public Object invoke(Object obj, Object entity) {
        try {
            Object result = this.method.invoke(obj, entity);
            if (this.returnsEntity) {
                return result;
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("The method [" + this.method + "] of the class [" + this.method.getDeclaringClass().getName() + "] threw an exception, while invoking it with the object [" + obj + "].", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("The method [" + this.method + "] of the class [" + this.method.getDeclaringClass().getName() + "] threw an exception, while invoking it with the object [" + obj + "].", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("The method [" + this.method + "] of the class [" + this.method.getDeclaringClass().getName() + "] threw an exception, while invoking it with the object [" + obj + "].", e);
        }
    }

    public Object invoke(Object obj, String id, Object entity) {
        try {
            Object result = this.method.invoke(obj, id, entity);
            if (this.returnsEntity) {
                return result;
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("The method [" + this.method + "] of the class [" + this.method.getDeclaringClass().getName() + "] threw an exception, while invoking it with the object [" + obj + "] and using the id '" + id + "'.", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("The method [" + this.method + "] of the class [" + this.method.getDeclaringClass().getName() + "] threw an exception, while invoking it with the object [" + obj + "] and using the id '" + id + "'.", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("The method [" + this.method + "] of the class [" + this.method.getDeclaringClass().getName() + "] threw an exception, while invoking it with the object [" + obj + "] and using the id '" + id + "'.", e);
        }
    }
}

