/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.admin.base;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.switchyard.admin.Application;
import org.switchyard.admin.ComponentReference;
import org.switchyard.admin.ComponentService;
import org.switchyard.admin.base.BaseComponentReference;
import org.switchyard.admin.base.BaseMessageMetricsAware;
import org.switchyard.config.model.composite.ComponentImplementationModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentReferenceModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.composite.InterfaceModel;

public abstract class BaseComponentService
extends BaseMessageMetricsAware
implements ComponentService {
    private final QName _name;
    private final String _implementation;
    private final String _interface;
    private final Application _application;
    private List<ComponentReference> _references;
    private final String _implementationConfiguration;

    public BaseComponentService(ComponentServiceModel serviceConfig, ComponentModel componentConfig, Application application) {
        this._name = serviceConfig.getQName();
        this._implementation = this.getComponentImplementationType(componentConfig);
        this._interface = this.getInterfaceName(serviceConfig.getInterface());
        this._application = application;
        this._references = new LinkedList<ComponentReference>();
        this._implementationConfiguration = this.getComponentImplementationConfiguration(componentConfig);
        for (ComponentReferenceModel referenceModel : componentConfig.getReferences()) {
            this._references.add(new BaseComponentReference(referenceModel.getQName(), this.getInterfaceName(referenceModel.getInterface())));
        }
    }

    @Override
    public QName getName() {
        return this._name;
    }

    @Override
    public String getImplementation() {
        return this._implementation;
    }

    @Override
    public String getInterface() {
        return this._interface;
    }

    @Override
    public List<ComponentReference> getReferences() {
        if (this._references == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this._references);
    }

    @Override
    public Application getApplication() {
        return this._application;
    }

    @Override
    public String getImplementationConfiguration() {
        return this._implementationConfiguration;
    }

    @Override
    public void resetMessageMetrics() {
        for (ComponentReference reference : this._references) {
            reference.resetMessageMetrics();
        }
        super.resetMessageMetrics();
    }

    private String getInterfaceName(InterfaceModel interfaceModel) {
        if (interfaceModel == null) {
            return null;
        }
        return interfaceModel.getInterface();
    }

    private String getComponentImplementationType(ComponentModel componentModel) {
        ComponentImplementationModel implementationModel = componentModel.getImplementation();
        if (implementationModel == null) {
            return null;
        }
        return implementationModel.getType();
    }

    private String getComponentImplementationConfiguration(ComponentModel componentModel) {
        return componentModel.getImplementation() != null ? componentModel.getImplementation().toString() : null;
    }
}

