/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.ui.bpel2svg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.wso2.carbon.bpel.ui.bpel2svg.ActivityInterface;
import org.wso2.carbon.bpel.ui.bpel2svg.Link;

public class LayoutManager {
    private int svgWidth = 1400;
    private int svgHeight = 1000;
    private int xSpacing = 20;
    private int ySpacing = 50;
    private boolean includeAssigns = true;
    private boolean showSequenceBoxes = true;
    private boolean verticalLayout = false;
    private boolean addCompositeActivityOpacity = false;
    private boolean addIconOpacity = false;
    private boolean addSimpleActivityOpacity = true;
    private double iconOpacity = 0.4;
    private double opacity = 0.5;
    private double simpleActivityOpacity = 0.351;
    private double compositeActivityOpacity = 0.1;
    private int startIconDim = 32;
    private int endIconDim = 22;
    private Map<ActivityInterface, ArrayList<ActivityInterface>> linkAdjacencyList;
    private Set<ActivityInterface> rootLinks;
    private int correctionCumulation = 0;
    private int hieghestCorrectionCumulation = 0;

    public int getSvgWidth() {
        return this.svgWidth;
    }

    public void setSvgWidth(int svgWidth) {
        this.svgWidth = svgWidth;
    }

    public int getSvgHeight() {
        return this.svgHeight;
    }

    public void setSvgHeight(int svgHeight) {
        this.svgHeight = svgHeight;
    }

    public int getXSpacing() {
        return this.xSpacing;
    }

    public void setXSpacing(int xSpacing) {
        this.xSpacing = xSpacing;
    }

    public int getYSpacing() {
        return this.ySpacing;
    }

    public void setYSpacing(int ySpacing) {
        this.ySpacing = ySpacing;
    }

    public boolean isIncludeAssigns() {
        return this.includeAssigns;
    }

    public void setIncludeAssigns(boolean includeAssigns) {
        this.includeAssigns = includeAssigns;
    }

    public boolean isShowSequenceBoxes() {
        return this.showSequenceBoxes;
    }

    public void setShowSequenceBoxes(boolean showSequenceBoxes) {
        this.showSequenceBoxes = showSequenceBoxes;
    }

    public boolean isVerticalLayout() {
        return this.verticalLayout;
    }

    public void setVerticalLayout(boolean verticalLayout) {
        this.verticalLayout = verticalLayout;
    }

    public boolean isAddCompositeActivityOpacity() {
        return this.addCompositeActivityOpacity;
    }

    public void setAddCompositeActivityOpacity(boolean addCompositeActivityOpacity) {
        this.addCompositeActivityOpacity = addCompositeActivityOpacity;
    }

    public boolean isAddIconOpacity() {
        return this.addIconOpacity;
    }

    public void setAddIconOpacity(boolean addIconOpacity) {
        this.addIconOpacity = addIconOpacity;
    }

    public boolean isAddSimpleActivityOpacity() {
        return this.addSimpleActivityOpacity;
    }

    public void setAddSimpleActivityOpacity(boolean addSimpleActivityOpacity) {
        this.addSimpleActivityOpacity = addSimpleActivityOpacity;
    }

    public double getCompositeActivityOpacity() {
        return this.compositeActivityOpacity;
    }

    public void setCompositeActivityOpacity(double compositeActivityOpacity) {
        this.compositeActivityOpacity = compositeActivityOpacity;
    }

    public double getIconOpacity(ActivityInterface.ActivityState state) {
        double ret = this.iconOpacity;
        if (state != ActivityInterface.ActivityState.Ready) {
            ret = 1.0;
        }
        return ret;
    }

    public void setIconOpacity(double iconOpacity) {
        this.iconOpacity = iconOpacity;
    }

    public double getOpacity() {
        return this.opacity;
    }

    public void setOpacity(double opacity) {
        this.opacity = opacity;
    }

    public double getSimpleActivityOpacity(ActivityInterface.ActivityState state) {
        double ret = this.simpleActivityOpacity;
        if (state == ActivityInterface.ActivityState.Active) {
            ret = 1.0;
        } else if (state == ActivityInterface.ActivityState.Completed || state == ActivityInterface.ActivityState.Failed) {
            ret += 0.3;
        }
        return ret;
    }

    public void setSimpleActivityOpacity(double simpleActivityOpacity) {
        this.simpleActivityOpacity = simpleActivityOpacity;
    }

    public int getStartIconDim() {
        return this.startIconDim;
    }

    public void setStartIconDim(int startIconDim) {
        this.startIconDim = startIconDim;
    }

    public int getEndIconDim() {
        return this.endIconDim;
    }

    public void setEndIconDim(int endIconDim) {
        this.endIconDim = endIconDim;
    }

    public void layoutSVG(ActivityInterface rootActivity) {
        rootActivity.getDimensions();
        this.layoutLinks(rootActivity);
        rootActivity.layout(0, 0);
    }

    private Map<ActivityInterface, ArrayList<ActivityInterface>> getLinkAdjacencyList(Map<String, Link> links) {
        HashMap<ActivityInterface, ArrayList<ActivityInterface>> linkAdjacencyList = new HashMap<ActivityInterface, ArrayList<ActivityInterface>>();
        if (links != null && !links.isEmpty()) {
            Set<Map.Entry<String, Link>> linksSet = links.entrySet();
            for (Map.Entry<String, Link> link : linksSet) {
                ActivityInterface startActivity = link.getValue().getSource();
                ActivityInterface endActivity = link.getValue().getTarget();
                if (linkAdjacencyList.containsKey(startActivity)) {
                    ((ArrayList)linkAdjacencyList.get(startActivity)).add(endActivity);
                    continue;
                }
                ArrayList<ActivityInterface> tmpArrayList = new ArrayList<ActivityInterface>();
                tmpArrayList.add(endActivity);
                linkAdjacencyList.put(startActivity, tmpArrayList);
            }
        }
        return linkAdjacencyList;
    }

    private void setCorrectionY(ActivityInterface source, ArrayList<ActivityInterface> children) {
        if (children != null && !children.isEmpty()) {
            for (ActivityInterface target : children) {
                int whereTargetShouldBe = source.getStartIconYTop() + source.getStartIconHeight() + 40;
                int whereTargetIs = target.getStartIconYTop();
                int correction = whereTargetShouldBe - whereTargetIs;
                if (whereTargetIs >= whereTargetShouldBe) continue;
                target.setCorrectionY(correction);
                int relativeCorrection = whereTargetShouldBe - source.getStartIconYTop();
                this.correctionCumulation += relativeCorrection;
                this.setCorrectionY(target, this.linkAdjacencyList.get(target));
                this.correctionCumulation -= relativeCorrection;
            }
        } else if (this.hieghestCorrectionCumulation < this.correctionCumulation) {
            this.hieghestCorrectionCumulation = this.correctionCumulation;
        }
    }

    private void layoutLinks(ActivityInterface rootActivity) {
        Map<String, Link> links = rootActivity.getLinks();
        if (links != null && !links.isEmpty()) {
            this.linkAdjacencyList = this.getLinkAdjacencyList(links);
            this.rootLinks = rootActivity.getLinkRoots();
            for (ActivityInterface root : this.rootLinks) {
                this.correctionCumulation = 0;
                this.setCorrectionY(root, this.linkAdjacencyList.get(root));
            }
            for (ActivityInterface tempParent = this.rootLinks.iterator().next().getParent(); tempParent != null; tempParent = tempParent.getParent()) {
                int tempHeight = tempParent.getDimensions().getHeight();
                tempParent.getDimensions().setHeight(tempHeight + this.hieghestCorrectionCumulation);
            }
            this.rootLinks.clear();
        }
    }
}

