/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.switchyard;

import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.DefaultProducer;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangePhase;
import org.switchyard.Message;
import org.switchyard.Scope;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.SwitchYardException;
import org.switchyard.common.camel.SwitchYardCamelContext;
import org.switchyard.component.camel.common.composer.BindingDataCreator;
import org.switchyard.component.camel.common.composer.BindingDataCreatorResolver;
import org.switchyard.component.camel.common.composer.CamelBindingData;
import org.switchyard.component.camel.switchyard.CamelResponseHandler;
import org.switchyard.component.camel.switchyard.ComponentNameComposer;
import org.switchyard.component.camel.switchyard.ExchangeMapper;
import org.switchyard.component.camel.switchyard.SwitchYardCamelComponentLogger;
import org.switchyard.component.camel.switchyard.SwitchYardCamelComponentMessages;
import org.switchyard.component.camel.switchyard.SwitchYardEndpoint;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.common.composer.MessageComposer;
import org.switchyard.component.common.composer.SecurityBindingData;
import org.switchyard.label.BehaviorLabel;
import org.switchyard.metadata.ServiceOperation;
import org.switchyard.policy.Policy;
import org.switchyard.policy.PolicyUtil;
import org.switchyard.policy.TransactionPolicy;
import org.switchyard.security.context.SecurityContextManager;
import org.switchyard.selector.OperationSelector;

public class SwitchYardProducer
extends DefaultProducer {
    private String _operationName;
    private final MessageComposer<CamelBindingData> _messageComposer;

    public SwitchYardProducer(Endpoint endpoint, String operationName, MessageComposer<CamelBindingData> messageComposer) {
        super(endpoint);
        this._operationName = operationName;
        this._messageComposer = messageComposer;
    }

    public void process(org.apache.camel.Exchange camelExchange) throws Exception {
        String namespace = (String)camelExchange.getProperty("org.switchyard.component.camel.namespace", String.class);
        String targetUri = this.getEndpoint().getEndpointUri();
        ServiceDomain domain = ((SwitchYardCamelContext)camelExchange.getContext()).getServiceDomain();
        ServiceReference serviceRef = this.lookupServiceReference(targetUri, namespace, domain, (QName)camelExchange.getProperty("org.switchyard.component.camel.componentName", QName.class));
        boolean isGatewayRoute = camelExchange.getProperty("org.switchyard.component.camel.implementation") == null;
        MessageComposer<CamelBindingData> composer = isGatewayRoute ? this.getMessageComposer(camelExchange) : null;
        Exchange switchyardExchange = this.createSwitchyardExchange(camelExchange, serviceRef, composer);
        if (camelExchange.isTransacted()) {
            PolicyUtil.provide((Exchange)switchyardExchange, (Policy)TransactionPolicy.PROPAGATES_TRANSACTION);
            PolicyUtil.provide((Exchange)switchyardExchange, (Policy)TransactionPolicy.MANAGED_TRANSACTION_GLOBAL);
        }
        Message switchyardMessage = isGatewayRoute ? this.composeForGateway(composer, camelExchange, switchyardExchange) : ExchangeMapper.mapCamelToSwitchYard(camelExchange, switchyardExchange, ExchangePhase.IN);
        switchyardExchange.send(switchyardMessage);
    }

    private Message composeForGateway(MessageComposer<CamelBindingData> composer, org.apache.camel.Exchange camelExchange, Exchange switchyardExchange) throws Exception {
        String gatewayName;
        BindingDataCreator<?> bindingCreator = this.getBindingDataCreator(camelExchange);
        CamelBindingData bindingData = bindingCreator.createBindingData(camelExchange.getIn());
        if (bindingData instanceof SecurityBindingData) {
            ServiceDomain serviceDomain = ((SwitchYardCamelContext)camelExchange.getContext()).getServiceDomain();
            SecurityContextManager securityContextManager = new SecurityContextManager(serviceDomain);
            securityContextManager.addCredentials(switchyardExchange, ((SecurityBindingData)bindingData).extractCredentials());
        }
        if ((gatewayName = (String)camelExchange.getProperty("org.switchyard.exchangeGatewayName", String.class)) != null) {
            switchyardExchange.getContext().setProperty("org.switchyard.exchangeGatewayName", (Object)gatewayName, Scope.EXCHANGE).addLabels(new String[]{BehaviorLabel.TRANSIENT.label()});
        }
        return composer.compose((BindingData)bindingData, switchyardExchange);
    }

    private BindingDataCreator<?> getBindingDataCreator(org.apache.camel.Exchange camelExchange) {
        BindingDataCreatorResolver resolver = ((SwitchYardEndpoint)this.getEndpoint()).getBindingDataCreatorResolver();
        String resolverKey = camelExchange.getFromEndpoint().getClass().getSimpleName();
        return resolver.resolveBindingCreator(resolverKey, this.getEndpoint().getCamelContext());
    }

    private String getOperationName(org.apache.camel.Exchange exchange) {
        String operationName = null;
        OperationSelector selector = (OperationSelector)exchange.getIn().getHeader("org.switchyard.operationSelector", OperationSelector.class);
        if (selector != null) {
            try {
                operationName = selector.selectOperation((Object)new CamelBindingData(exchange.getIn())).getLocalPart();
            }
            catch (Exception e) {
                SwitchYardCamelComponentLogger.ROOT_LOGGER.cannotLookupOperation(e);
            }
        }
        return operationName;
    }

    private MessageComposer<CamelBindingData> getMessageComposer(org.apache.camel.Exchange exchange) {
        MessageComposer<CamelBindingData> composer = (MessageComposer<CamelBindingData>)exchange.getIn().getHeader("org.switchyard.messageComposer", MessageComposer.class);
        return composer == null ? this._messageComposer : composer;
    }

    private ServiceReference lookupServiceReference(String targetUri, String namespace, ServiceDomain domain, QName componentName) {
        QName serviceName = ComponentNameComposer.composeSwitchYardServiceName(namespace, targetUri, componentName);
        ServiceReference serviceRef = domain.getServiceReference(serviceName);
        if (serviceRef == null) {
            throw SwitchYardCamelComponentMessages.MESSAGES.noServiceReferenceFoundForURI(targetUri);
        }
        return serviceRef;
    }

    private Exchange createSwitchyardExchange(org.apache.camel.Exchange camelExchange, ServiceReference serviceRef, MessageComposer<CamelBindingData> messageComposer) {
        String opName = this.lookupOperationNameFor(camelExchange, serviceRef);
        CamelResponseHandler handler = new CamelResponseHandler(camelExchange, serviceRef, messageComposer);
        if (opName != null) {
            return serviceRef.createExchange(opName, (ExchangeHandler)handler);
        }
        return serviceRef.createExchange((ExchangeHandler)handler);
    }

    private String lookupOperationNameFor(org.apache.camel.Exchange camelExchange, ServiceReference serviceRef) {
        String operationName = this._operationName;
        if (operationName == null) {
            operationName = this.getOperationName(camelExchange);
        }
        if (operationName == null) {
            Set ops = serviceRef.getInterface().getOperations();
            if (ops.size() == 1) {
                operationName = ((ServiceOperation)ops.iterator().next()).getName();
            } else {
                String camelOp = (String)camelExchange.getProperty("org.switchyard.operationName", String.class);
                if (serviceRef.getInterface().getOperation(camelOp) != null) {
                    operationName = camelOp;
                }
            }
        }
        if (operationName == null) {
            StringBuilder msg = new StringBuilder();
            msg.append(SwitchYardCamelComponentMessages.MESSAGES.unableToDetermineOperation());
            msg.append(serviceRef.getInterface().getOperations());
            throw new SwitchYardException(msg.toString());
        }
        return operationName;
    }
}

