/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension;

import java.util.HashMap;
import java.util.Map;

public enum Element {
    UNKNOWN(null),
    SOCKET_BINDING("socket-binding"),
    SECURITY_CONFIGS("security-configs"),
    SECURITY_CONFIG("security-config"),
    MODULES("modules"),
    MODULE("module"),
    EXTENSIONS("extensions"),
    EXTENSION("extension"),
    PROPERTIES("properties");

    private final String _name;
    private static final Map<String, Element> MAP;

    private Element(String name) {
        this._name = name;
    }

    public String getLocalName() {
        return this._name;
    }

    public static Element forName(String localName) {
        Element element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    public String toString() {
        return this.getLocalName();
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

