/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.admin;

import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.switchyard.admin.Application;
import org.switchyard.admin.Reference;
import org.switchyard.admin.Service;
import org.switchyard.admin.SwitchYard;
import org.switchyard.as7.extension.ExtensionMessages;
import org.switchyard.as7.extension.services.SwitchYardAdminService;

public final class SwitchYardSubsystemStopGateway
implements OperationStepHandler {
    public static final SwitchYardSubsystemStopGateway INSTANCE = new SwitchYardSubsystemStopGateway();
    private Logger _log = Logger.getLogger(SwitchYardSubsystemStopGateway.class);

    private SwitchYardSubsystemStopGateway() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                Reference reference;
                QName serviceQName;
                Service service;
                ServiceController controller = context.getServiceRegistry(false).getRequiredService(SwitchYardAdminService.SERVICE_NAME);
                SwitchYard switchYard = (SwitchYard)SwitchYard.class.cast(controller.getService().getValue());
                String bindingName = operation.get("name").asString();
                Application application = switchYard.getApplication(QName.valueOf(operation.get("application-name").asString()));
                Object binding = application == null ? null : ((service = application.getService(serviceQName = QName.valueOf(operation.get("service-name").asString()))) == null ? ((reference = application.getReference(serviceQName)) == null ? null : reference.getGateway(bindingName)) : service.getGateway(bindingName));
                if (binding != null) {
                    try {
                        binding.stop();
                        context.stepCompleted();
                    }
                    catch (Throwable e) {
                        String err = ExtensionMessages.MESSAGES.errorStoppingGateway() + e.getMessage();
                        SwitchYardSubsystemStopGateway.this._log.error((Object)err);
                        if (SwitchYardSubsystemStopGateway.this._log.isDebugEnabled()) {
                            SwitchYardSubsystemStopGateway.this._log.debug((Object)err, e);
                        }
                        throw new OperationFailedException(new ModelNode().set(err));
                    }
                    return;
                }
                throw new OperationFailedException(new ModelNode().set(ExtensionMessages.MESSAGES.unknownGateway()));
            }
        }, OperationContext.Stage.RUNTIME);
        context.stepCompleted();
    }
}

