/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.http;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.naming.NamingException;
import javax.servlet.Servlet;
import org.apache.catalina.Container;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.ContextConfig;
import org.apache.tomcat.InstanceManager;
import org.jboss.as.web.deployment.WebCtxLoader;
import org.jboss.logging.Logger;
import org.switchyard.ServiceDomain;
import org.switchyard.as7.extension.ExtensionMessages;
import org.switchyard.as7.extension.http.JBossWebEndpoint;
import org.switchyard.as7.extension.util.ServerUtil;
import org.switchyard.component.common.Endpoint;
import org.switchyard.component.http.HttpGatewayServlet;
import org.switchyard.component.http.InboundHandler;
import org.switchyard.component.http.endpoint.EndpointPublisher;

public class JBossWebEndpointPublisher
implements EndpointPublisher {
    private static final Logger LOG = Logger.getLogger((String)"org.switchyard");
    private static final String SERVER_TEMP_DIR = System.getProperty("jboss.server.temp.dir");
    private static final String SERVLET_NAME = "HttpGatewayServlet";

    public synchronized Endpoint publish(ServiceDomain domain, String context, InboundHandler handler) throws Exception {
        File docBase;
        Host host = ServerUtil.getDefaultHost().getHost();
        StandardContext serverContext = (StandardContext)host.findChild("/" + context);
        if (serverContext == null) {
            serverContext = new StandardContext();
            serverContext.setPath("/" + context);
            docBase = new File(SERVER_TEMP_DIR, context);
            if (!docBase.exists() && !docBase.mkdirs()) {
                throw ExtensionMessages.MESSAGES.unableToCreateTempDirectory(docBase.getPath());
            }
        } else {
            throw ExtensionMessages.MESSAGES.contextAlreadyExists(context);
        }
        serverContext.setDocBase(docBase.getPath());
        serverContext.addLifecycleListener((LifecycleListener)new ContextConfig());
        WebCtxLoader loader = new WebCtxLoader(Thread.currentThread().getContextClassLoader());
        loader.setContainer((Container)host);
        serverContext.setLoader((Loader)loader);
        serverContext.setInstanceManager((InstanceManager)new LocalInstanceManager());
        Wrapper wrapper = serverContext.createWrapper();
        wrapper.setName(SERVLET_NAME);
        wrapper.setServletClass(HttpGatewayServlet.class.getName());
        wrapper.setServlet((Servlet)new HttpGatewayServlet());
        wrapper.setLoadOnStartup(1);
        serverContext.addChild((Container)wrapper);
        serverContext.addServletMapping("/*", SERVLET_NAME);
        host.addChild((Container)serverContext);
        serverContext.create();
        serverContext.start();
        HttpGatewayServlet instance = (HttpGatewayServlet)wrapper.getServlet();
        instance.setHandler(handler);
        LOG.info((Object)("Published HTTP context " + serverContext.getPath()));
        return new JBossWebEndpoint(serverContext);
    }

    private static class LocalInstanceManager
    implements InstanceManager {
        LocalInstanceManager() {
        }

        public Object newInstance(String className) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
            return Class.forName(className).newInstance();
        }

        public Object newInstance(String fqcn, ClassLoader classLoader) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
            return Class.forName(fqcn, false, classLoader).newInstance();
        }

        public Object newInstance(Class<?> c) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException {
            return c.newInstance();
        }

        public void newInstance(Object o) throws IllegalAccessException, InvocationTargetException, NamingException {
            throw new IllegalStateException();
        }

        public void destroyInstance(Object o) throws IllegalAccessException, InvocationTargetException {
        }
    }
}

