/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security.login;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.switchyard.common.lang.Strings;
import org.switchyard.security.BaseSecurityMessages;

public abstract class SwitchYardLoginModule
implements LoginModule {
    private Subject _subject;
    private CallbackHandler _callbackHandler;
    private Map<String, ?> _sharedState;
    private Map<String, ?> _options;

    public Subject getSubject() {
        return this._subject;
    }

    public CallbackHandler getCallbackHandler() {
        return this._callbackHandler;
    }

    public Map<String, ?> getSharedState() {
        return this._sharedState;
    }

    public Map<String, ?> getOptions() {
        return this._options;
    }

    public String getOption(String name) {
        return this.getOption(name, false);
    }

    public String getOption(String name, boolean required) {
        Map<String, ?> options = this.getOptions();
        if (options == null) {
            if (required) {
                throw BaseSecurityMessages.MESSAGES.optionsNotSet();
            }
        } else {
            Object value = options.get(name);
            if (value != null) {
                return Strings.replaceSystemAndTestProperties((String)String.valueOf(value));
            }
            if (required) {
                throw BaseSecurityMessages.MESSAGES.optionNotSet(name);
            }
        }
        return null;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this._subject = subject;
        this._callbackHandler = callbackHandler;
        this._sharedState = sharedState;
        this._options = options;
    }

    @Override
    public boolean login() throws LoginException {
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        return true;
    }
}

