/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.handlers;

import java.util.Arrays;
import java.util.HashSet;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.switchyard.BaseHandler;
import org.switchyard.Exchange;
import org.switchyard.ExchangePhase;
import org.switchyard.HandlerException;
import org.switchyard.Property;
import org.switchyard.internal.transform.BaseTransformerRegistry;
import org.switchyard.label.BehaviorLabel;
import org.switchyard.metadata.JavaTypes;
import org.switchyard.metadata.ServiceOperation;
import org.switchyard.runtime.RuntimeMessages;
import org.switchyard.transform.TransformSequence;
import org.switchyard.transform.Transformer;
import org.switchyard.transform.TransformerRegistry;

public class TransformHandler
extends BaseHandler {
    private static Logger _logger = Logger.getLogger(TransformHandler.class);
    private TransformerRegistry _registry;

    public TransformHandler(TransformerRegistry registry) {
        this._registry = registry;
    }

    public TransformHandler(Transformer<?, ?> ... transforms) {
        if (transforms != null && transforms.length > 0) {
            this._registry = new BaseTransformerRegistry(new HashSet(Arrays.asList(transforms)));
        }
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        if (exchange.getPhase() == ExchangePhase.IN) {
            this.initInTransformSequence(exchange);
        } else {
            this.initOutTransformSequence(exchange);
        }
        TransformSequence transformSequence = this._registry.getTransformSequence(TransformSequence.getCurrentMessageType((Exchange)exchange), TransformSequence.getTargetMessageType((Exchange)exchange));
        if (transformSequence != null) {
            transformSequence.associateWith(exchange.getMessage());
        }
        TransformSequence.applySequence((Exchange)exchange, (TransformerRegistry)this._registry);
        if (!TransformSequence.assertTransformsApplied((Exchange)exchange)) {
            QName actualPayloadType = TransformSequence.getCurrentMessageType((Exchange)exchange);
            QName expectedPayloadType = TransformSequence.getTargetMessageType((Exchange)exchange);
            throw RuntimeMessages.MESSAGES.transformationsNotApplied(expectedPayloadType.toString(), actualPayloadType.toString());
        }
        this.setContentType(exchange);
    }

    public void handleFault(Exchange exchange) {
        this.initFaultTransformSequence(exchange);
        TransformSequence.applySequence((Exchange)exchange, (TransformerRegistry)this._registry);
        if (!TransformSequence.assertTransformsApplied((Exchange)exchange)) {
            QName actualPayloadType = TransformSequence.getCurrentMessageType((Exchange)exchange);
            QName expectedPayloadType = TransformSequence.getTargetMessageType((Exchange)exchange);
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Transformations not applied.  Required payload type of '" + expectedPayloadType + "'.  Actual payload type is '" + actualPayloadType + "'.  You must define and register a Transformer to transform between these types."));
            }
        }
        this.setContentType(exchange);
    }

    private void setContentType(Exchange exchange) {
        QName currentType = TransformSequence.getCurrentMessageType((Exchange)exchange);
        if (currentType != null) {
            exchange.getContext().setProperty("org.switchyard.contentType", (Object)currentType).addLabels(new String[]{BehaviorLabel.TRANSIENT.label()});
        } else {
            Property p = exchange.getContext().getProperty("org.switchyard.contentType");
            if (p != null) {
                exchange.getContext().removeProperty(p);
            }
        }
    }

    private void initInTransformSequence(Exchange exchange) {
        QName exchangeInputType = exchange.getContract().getConsumerOperation().getInputType();
        QName serviceOperationInputType = exchange.getContract().getProviderOperation().getInputType();
        if (exchangeInputType != null && serviceOperationInputType != null) {
            TransformSequence.from((QName)exchangeInputType).to(serviceOperationInputType).associateWith(exchange.getMessage());
        }
    }

    private void initOutTransformSequence(Exchange exchange) {
        QName serviceOperationOutputType = exchange.getContract().getProviderOperation().getOutputType();
        QName exchangeOutputType = exchange.getContract().getConsumerOperation().getOutputType();
        if (serviceOperationOutputType != null && exchangeOutputType != null) {
            TransformSequence.from((QName)serviceOperationOutputType).to(exchangeOutputType).associateWith(exchange.getMessage());
        }
    }

    private void initFaultTransformSequence(Exchange exchange) {
        QName exceptionTypeName = null;
        ServiceOperation providerOperation = exchange.getContract().getProviderOperation();
        ServiceOperation consumerOperation = exchange.getContract().getConsumerOperation();
        QName invokerFaultTypeName = consumerOperation.getFaultType();
        if (providerOperation != null) {
            exceptionTypeName = providerOperation.getFaultType();
        }
        Object content = exchange.getMessage().getContent();
        if (exceptionTypeName == null && content instanceof Exception) {
            exceptionTypeName = JavaTypes.toMessageType(content.getClass());
        }
        if (exceptionTypeName != null && invokerFaultTypeName != null) {
            TransformSequence.from((QName)exceptionTypeName).to(invokerFaultTypeName).associateWith(exchange.getMessage());
        }
    }
}

