/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.switchyard.ExchangeHandler;
import org.switchyard.Service;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceMetadata;
import org.switchyard.ServiceReference;
import org.switchyard.ServiceSecurity;
import org.switchyard.event.DomainShutdownEvent;
import org.switchyard.event.DomainStartupEvent;
import org.switchyard.event.EventObserver;
import org.switchyard.event.EventPublisher;
import org.switchyard.event.ReferenceRegistrationEvent;
import org.switchyard.event.ServiceRegistrationEvent;
import org.switchyard.internal.DefaultServiceRegistry;
import org.switchyard.internal.EventManager;
import org.switchyard.internal.LocalExchangeBus;
import org.switchyard.internal.ServiceImpl;
import org.switchyard.internal.ServiceReferenceImpl;
import org.switchyard.internal.transform.BaseTransformerRegistry;
import org.switchyard.internal.validate.BaseValidatorRegistry;
import org.switchyard.metadata.InOutService;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.security.service.DefaultServiceDomainSecurity;
import org.switchyard.security.service.SecureServiceDomain;
import org.switchyard.security.service.ServiceDomainSecurity;
import org.switchyard.spi.Dispatcher;
import org.switchyard.spi.ExchangeBus;
import org.switchyard.spi.ServiceRegistry;
import org.switchyard.transform.TransformerRegistry;
import org.switchyard.validate.ValidatorRegistry;

public class DomainImpl
implements SecureServiceDomain {
    private static Logger _logger = Logger.getLogger(DomainImpl.class);
    private final QName _name;
    private EventManager _eventManager;
    private ServiceRegistry _serviceRegistry;
    private ExchangeBus _exchangeBus;
    private TransformerRegistry _transformerRegistry;
    private ValidatorRegistry _validatorRegistry;
    private Map<String, Object> _properties = new ConcurrentHashMap<String, Object>();
    private ServiceDomainSecurity _serviceDomainSecurity;

    protected DomainImpl(QName name) {
        this(name, new DefaultServiceRegistry(), new LocalExchangeBus(), new BaseTransformerRegistry(), new BaseValidatorRegistry(), new EventManager(), (ServiceDomainSecurity)new DefaultServiceDomainSecurity());
        this.init();
    }

    public DomainImpl(QName name, ServiceRegistry serviceRegistry, ExchangeBus exchangeBus, TransformerRegistry transformerRegistry, ValidatorRegistry validatorRegistry, EventManager eventManager, ServiceDomainSecurity serviceDomainSecurity) {
        this._name = name;
        this._serviceRegistry = serviceRegistry;
        this._exchangeBus = exchangeBus;
        this._transformerRegistry = transformerRegistry;
        this._validatorRegistry = validatorRegistry;
        this._eventManager = eventManager;
        this._serviceDomainSecurity = serviceDomainSecurity;
        this.setEventPublisher(this._transformerRegistry);
        this.setEventPublisher(this._validatorRegistry);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Created SwitchYard ServiceDomain instance '" + name + "'."));
        }
    }

    public Service registerService(QName serviceName, ServiceInterface contract, ExchangeHandler handler) {
        return this.registerService(serviceName, contract, handler, null);
    }

    public Service registerService(QName serviceName, ServiceInterface contract, ExchangeHandler handler, ServiceMetadata metadata) {
        if (contract == null) {
            contract = new InOutService();
        }
        ServiceImpl service = new ServiceImpl(serviceName, contract, this, handler, metadata);
        this._serviceRegistry.registerService(service);
        this._eventManager.publish((EventObject)new ServiceRegistrationEvent((Service)service));
        return service;
    }

    public ServiceReference registerServiceReference(QName serviceName, ServiceInterface contract) {
        return this.registerServiceReference(serviceName, contract, null);
    }

    public ServiceReference registerServiceReference(QName serviceName, ServiceInterface contract, ExchangeHandler handler) {
        return this.registerServiceReference(serviceName, contract, handler, null);
    }

    public ServiceReference registerServiceReference(QName serviceName, ServiceInterface contract, ExchangeHandler handler, ServiceMetadata metadata) {
        ServiceReferenceImpl reference = new ServiceReferenceImpl(serviceName, contract, this, handler, metadata);
        Dispatcher dispatch = this._exchangeBus.createDispatcher(reference);
        reference.setDispatcher(dispatch);
        this._serviceRegistry.registerServiceReference(reference);
        this._eventManager.publish((EventObject)new ReferenceRegistrationEvent((ServiceReference)reference));
        return reference;
    }

    public ServiceReference getServiceReference(QName serviceName) {
        return this._serviceRegistry.getServiceReference(serviceName);
    }

    public QName getName() {
        return this._name;
    }

    public TransformerRegistry getTransformerRegistry() {
        return this._transformerRegistry;
    }

    public ValidatorRegistry getValidatorRegistry() {
        return this._validatorRegistry;
    }

    public List<Service> getServices() {
        return this._serviceRegistry.getServices();
    }

    public List<Service> getServices(QName serviceName) {
        return this._serviceRegistry.getServices(serviceName);
    }

    public ServiceRegistry getServiceRegistry() {
        return this._serviceRegistry;
    }

    public ExchangeBus getBus() {
        return this._exchangeBus;
    }

    public void init() {
        this._eventManager.publish((EventObject)new DomainStartupEvent((ServiceDomain)this));
        this._exchangeBus.init((ServiceDomain)this);
        this._exchangeBus.start();
    }

    public void destroy() {
        this._exchangeBus.stop();
        this._eventManager.publish((EventObject)new DomainShutdownEvent((ServiceDomain)this));
    }

    public ServiceDomain addEventObserver(EventObserver observer, Class<? extends EventObject> eventType) {
        this._eventManager.addObserver(observer, eventType);
        return this;
    }

    public EventPublisher getEventPublisher() {
        return this._eventManager;
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this._properties);
    }

    public Object getProperty(String name) {
        return this._properties.get(name);
    }

    public ServiceDomain setProperty(String name, Object value) {
        if (value != null) {
            this._properties.put(name, value);
        } else {
            this._properties.remove(name);
        }
        return this;
    }

    private void setEventPublisher(Object target) {
        if (target == null) {
            return;
        }
        try {
            Method setter = target.getClass().getMethod("setEventPublisher", EventPublisher.class);
            setter.invoke(target, this._eventManager);
        }
        catch (Exception ex) {
            _logger.debug((Object)("Attempt to set EventPublisher failed on " + target.getClass().getCanonicalName()), (Throwable)ex);
        }
    }

    public ServiceSecurity getServiceSecurity(String name) {
        return this.getServiceDomainSecurity().getServiceSecurity(name);
    }

    public ServiceDomainSecurity getServiceDomainSecurity() {
        return this._serviceDomainSecurity;
    }

    public String toString() {
        return "ServiceDomain [name=" + this._name + "]";
    }

    public void removeObserver(EventObserver observer) {
        this._eventManager.removeObserver(observer);
    }

    public void removeObserverForEvent(EventObserver observer, Class<? extends EventObject> eventType) {
        this._eventManager.removeObserverForEvent(observer, eventType);
    }
}

