/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.services;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.overlord.commons.services.AbstractServiceRegistry;
import org.overlord.commons.services.Messages;

public class ServiceLoaderServiceRegistry
extends AbstractServiceRegistry {
    private static final Logger LOG = Logger.getLogger(ServiceLoaderServiceRegistry.class.getName());
    private Map<Class<?>, Set<?>> servicesCache = new HashMap();

    @Override
    public <T> T getSingleService(Class<T> serviceInterface) throws IllegalStateException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Get single service for class: " + serviceInterface);
        }
        T rval = null;
        Set<T> services = this.getServices(serviceInterface);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Found services: " + services);
        }
        if (services.size() > 1) {
            throw new IllegalStateException(Messages.getString("ServiceLoaderServiceRegistry.MultipleImplsFound") + serviceInterface);
        }
        if (!services.isEmpty()) {
            rval = services.iterator().next();
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Returning service: " + rval);
        }
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Set<T> getServices(Class<T> serviceInterface) {
        Map<Class<?>, Set<?>> map = this.servicesCache;
        synchronized (map) {
            LinkedHashSet<T> services;
            block10: {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Get services for class: " + serviceInterface);
                    LOG.finest("Service Registry Details: registry=" + this + " registry classloader=" + this.getClass().getClassLoader() + " tccl=" + Thread.currentThread().getContextClassLoader() + " cache=" + this.servicesCache);
                }
                if (this.servicesCache.containsKey(serviceInterface)) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Returning existing services: " + this.servicesCache.get(serviceInterface));
                    }
                    return this.servicesCache.get(serviceInterface);
                }
                services = new LinkedHashSet<T>();
                try {
                    for (T service : ServiceLoader.load(serviceInterface)) {
                        this.init(service);
                        services.add(service);
                    }
                }
                catch (ServiceConfigurationError sce) {
                    if (!LOG.isLoggable(Level.FINE)) break block10;
                    LOG.log(Level.FINE, "ERROR while loading services for interface=" + serviceInterface, sce);
                }
            }
            this.servicesCache.put(serviceInterface, services);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Returning services: " + services);
            }
            return services;
        }
    }
}

