/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Provider;
import javax.xml.ws.WebServiceProvider;
import javax.xml.ws.handler.Handler;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelException;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.component.cxf.CxfBinding;
import org.apache.camel.component.cxf.CxfComponent;
import org.apache.camel.component.cxf.CxfConsumer;
import org.apache.camel.component.cxf.CxfEndpointConfigurer;
import org.apache.camel.component.cxf.CxfEndpointUtils;
import org.apache.camel.component.cxf.CxfPayload;
import org.apache.camel.component.cxf.CxfProducer;
import org.apache.camel.component.cxf.DataFormat;
import org.apache.camel.component.cxf.DefaultCxfBinding;
import org.apache.camel.component.cxf.DefaultPayloadProviderSEI;
import org.apache.camel.component.cxf.DefaultSEI;
import org.apache.camel.component.cxf.HybridSourceDataBinding;
import org.apache.camel.component.cxf.NullFaultListener;
import org.apache.camel.component.cxf.WSDLServiceFactoryBean;
import org.apache.camel.component.cxf.common.header.CxfHeaderFilterStrategy;
import org.apache.camel.component.cxf.feature.CXFMessageDataFormatFeature;
import org.apache.camel.component.cxf.feature.PayLoadDataFormatFeature;
import org.apache.camel.component.cxf.feature.RAWDataFormatFeature;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.SynchronousDelegateProducer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.binding.BindingConfiguration;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.injection.ResourceInjector;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.common.util.ModCountCopyOnWriteArrayList;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.source.SourceDataBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientImpl;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.feature.LoggingFeature;
import org.apache.cxf.frontend.AbstractWSDLBasedEndpointFactory;
import org.apache.cxf.frontend.ClientFactoryBean;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.headers.Header;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxws.JaxWsClientFactoryBean;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.jaxws.context.WebServiceContextResourceResolver;
import org.apache.cxf.jaxws.handler.AnnotationHandlerChainBuilder;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.logging.FaultListener;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.resource.DefaultResourceManager;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.StaxSource;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.wsdl.WSDLManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@UriEndpoint(scheme="cxf", title="CXF", syntax="cxf:beanId:address", consumerClass=CxfConsumer.class, label="http,soap,webservice")
public class CxfEndpoint
extends DefaultEndpoint
implements HeaderFilterStrategyAware,
Service,
Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(CxfEndpoint.class);
    protected Bus bus;
    @UriPath(description="To lookup an existing configured CxfEndpoint. Must used bean: as prefix.")
    private String beanId;
    @UriPath
    private String address;
    @UriParam
    private boolean createBus;
    @UriParam
    private String wsdlURL;
    private Class<?> serviceClass;
    private QName portName;
    private QName serviceName;
    @UriParam
    private String portNameString;
    @UriParam
    private String serviceNameString;
    @UriParam
    private String defaultOperationName;
    @UriParam
    private String defaultOperationNamespace;
    @UriParam
    private boolean isWrapped;
    @UriParam
    private Boolean wrappedStyle;
    @UriParam
    private Boolean allowStreaming;
    @UriParam(defaultValue="POJO")
    private DataFormat dataFormat = DataFormat.POJO;
    @UriParam
    private String publishedEndpointUrl;
    @UriParam(defaultValue="true")
    private boolean inOut = true;
    private CxfBinding cxfBinding;
    private HeaderFilterStrategy headerFilterStrategy;
    private AtomicBoolean getBusHasBeenCalled = new AtomicBoolean(false);
    @UriParam
    private boolean isSetDefaultBus;
    @UriParam
    private boolean loggingFeatureEnabled;
    @UriParam
    private int loggingSizeLimit;
    @UriParam
    private boolean mtomEnabled;
    @UriParam
    private boolean skipPayloadMessagePartCheck;
    @UriParam
    private boolean skipFaultLogging;
    @UriParam
    private boolean mergeProtocolHeaders;
    private Map<String, Object> properties;
    private List<Interceptor<? extends Message>> in = new ModCountCopyOnWriteArrayList();
    private List<Interceptor<? extends Message>> out = new ModCountCopyOnWriteArrayList();
    private List<Interceptor<? extends Message>> outFault = new ModCountCopyOnWriteArrayList();
    private List<Interceptor<? extends Message>> inFault = new ModCountCopyOnWriteArrayList();
    private List<Feature> features = new ModCountCopyOnWriteArrayList();
    private List<Handler> handlers;
    private List<String> schemaLocations;
    @UriParam
    private String transportId;
    @UriParam
    private String bindingId;
    private BindingConfiguration bindingConfig;
    private DataBinding dataBinding;
    private Object serviceFactoryBean;
    private CxfEndpointConfigurer configurer;
    @UriParam(defaultValue="30000")
    private long continuationTimeout = 30000L;
    @UriParam
    private String username;
    @UriParam
    private String password;

    public CxfEndpoint() {
    }

    public CxfEndpoint(String remaining, CxfComponent cxfComponent) {
        super(remaining, (Component)cxfComponent);
        this.setAddress(remaining);
    }

    @Deprecated
    public CxfEndpoint(String remaining, CamelContext context) {
        super(remaining, context);
        this.setAddress(remaining);
    }

    @Deprecated
    public CxfEndpoint(String remaining) {
        super(remaining);
        this.setAddress(remaining);
    }

    public CxfEndpoint copy() {
        try {
            return (CxfEndpoint)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    protected void updateEndpointUri(String endpointUri) {
        super.setEndpointUri(UnsafeUriCharactersEncoder.encodeHttpURI((String)endpointUri));
    }

    public Producer createProducer() throws Exception {
        CxfProducer answer = new CxfProducer(this);
        if (this.isSynchronous()) {
            return new SynchronousDelegateProducer((Producer)answer);
        }
        return answer;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        CxfConsumer answer = new CxfConsumer(this, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public boolean isSingleton() {
        return true;
    }

    protected void setupServerFactoryBean(ServerFactoryBean sfb, Class<?> cls) {
        sfb.setAddress(this.getAddress());
        sfb.setServiceClass(cls);
        sfb.setInInterceptors(this.in);
        sfb.setOutInterceptors(this.out);
        sfb.setOutFaultInterceptors(this.outFault);
        sfb.setInFaultInterceptors(this.inFault);
        sfb.setFeatures(this.features);
        if (this.schemaLocations != null) {
            sfb.setSchemaLocations(this.schemaLocations);
        }
        if (this.bindingConfig != null) {
            sfb.setBindingConfig(this.bindingConfig);
        }
        if (this.dataBinding != null) {
            sfb.setDataBinding(this.dataBinding);
        }
        if (this.serviceFactoryBean != null) {
            this.setServiceFactory(sfb, this.serviceFactoryBean);
        }
        if (sfb instanceof JaxWsServerFactoryBean && this.handlers != null) {
            ((JaxWsServerFactoryBean)sfb).setHandlers(this.handlers);
        }
        if (this.getTransportId() != null) {
            sfb.setTransportId(this.getTransportId());
        }
        if (this.getBindingId() != null) {
            sfb.setBindingId(this.getBindingId());
        }
        if (this.getWsdlURL() != null) {
            sfb.setWsdlURL(this.getWsdlURL());
        }
        if (this.getServiceName() != null) {
            sfb.setServiceName(this.getServiceName());
        }
        if (this.getPortName() != null) {
            sfb.setEndpointName(this.getPortName());
        }
        if (!CxfEndpointUtils.hasAnnotation(cls, WebServiceProvider.class)) {
            if (this.getDataFormat() == DataFormat.PAYLOAD) {
                sfb.getFeatures().add(new PayLoadDataFormatFeature(this.allowStreaming));
            } else if (this.getDataFormat().dealias() == DataFormat.CXF_MESSAGE) {
                sfb.getFeatures().add(new CXFMessageDataFormatFeature());
                sfb.setDataBinding((DataBinding)new SourceDataBinding());
            } else if (this.getDataFormat().dealias() == DataFormat.RAW) {
                RAWDataFormatFeature feature = new RAWDataFormatFeature();
                feature.addInIntercepters(this.getInInterceptors());
                feature.addOutInterceptors(this.getOutInterceptors());
                sfb.getFeatures().add(feature);
            }
        } else {
            LOG.debug("Ignore DataFormat mode {} since SEI class is annotated with WebServiceProvider", (Object)this.getDataFormat());
        }
        if (this.isLoggingFeatureEnabled()) {
            if (this.getLoggingSizeLimit() > 0) {
                sfb.getFeatures().add(new LoggingFeature(this.getLoggingSizeLimit()));
            } else {
                sfb.getFeatures().add(new LoggingFeature());
            }
        }
        if (this.getDataFormat() == DataFormat.PAYLOAD) {
            sfb.setDataBinding((DataBinding)new HybridSourceDataBinding());
        }
        if (this.getWrappedStyle() != null && this.getDataFormat().dealias() != DataFormat.CXF_MESSAGE) {
            this.setWrapped(sfb, this.getWrappedStyle());
        }
        if (this.getProperties() != null) {
            if (sfb.getProperties() != null) {
                sfb.getProperties().putAll(this.getProperties());
            } else {
                sfb.setProperties(this.getProperties());
            }
            LOG.debug("ServerFactoryBean: {} added properties: {}", (Object)sfb, this.getProperties());
        }
        if (this.isSkipPayloadMessagePartCheck()) {
            if (sfb.getProperties() == null) {
                sfb.setProperties(new HashMap());
            }
            sfb.getProperties().put("soap.no.validate.parts", Boolean.TRUE);
        }
        if (this.isSkipFaultLogging()) {
            if (sfb.getProperties() == null) {
                sfb.setProperties(new HashMap());
            }
            sfb.getProperties().put(FaultListener.class.getName(), new NullFaultListener());
        }
        sfb.setBus(this.getBus());
        sfb.setStart(false);
        if (this.getCxfEndpointConfigurer() != null) {
            this.getCxfEndpointConfigurer().configure((AbstractWSDLBasedEndpointFactory)sfb);
        }
    }

    protected ClientFactoryBean createClientFactoryBean(Class<?> cls) throws CamelException {
        if (CxfEndpointUtils.hasWebServiceAnnotation(cls)) {
            return new JaxWsClientFactoryBean(){

                protected Client createClient(Endpoint ep) {
                    return new CamelCxfClientImpl(this.getBus(), ep);
                }
            };
        }
        return new ClientFactoryBean(){

            protected Client createClient(Endpoint ep) {
                return new CamelCxfClientImpl(this.getBus(), ep);
            }
        };
    }

    protected ClientFactoryBean createClientFactoryBean() {
        ClientFactoryBean cf = new ClientFactoryBean(){

            protected Client createClient(Endpoint ep) {
                return new CamelCxfClientImpl(this.getBus(), ep);
            }

            protected void initializeAnnotationInterceptors(Endpoint ep, Class<?> cls) {
            }
        };
        for (Method m : cf.getClass().getMethods()) {
            if (!"setServiceFactory".equals(m.getName())) continue;
            try {
                ((Method)ReflectionUtil.setAccessible((AccessibleObject)m)).invoke((Object)cf, new Object[]{new WSDLServiceFactoryBean(Object.class)});
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return cf;
    }

    protected void setupHandlers(ClientFactoryBean factoryBean, Client client) throws Exception {
        if (factoryBean instanceof JaxWsClientFactoryBean && this.handlers != null) {
            AnnotationHandlerChainBuilder builder = new AnnotationHandlerChainBuilder();
            Method m = factoryBean.getClass().getMethod("getServiceFactory", new Class[0]);
            JaxWsServiceFactoryBean sf = (JaxWsServiceFactoryBean)m.invoke((Object)factoryBean, new Object[0]);
            ArrayList<Handler> chain = new ArrayList<Handler>(this.handlers);
            chain.addAll(builder.buildHandlerChainFromClass(sf.getServiceClass(), sf.getEndpointInfo().getName(), sf.getServiceQName(), factoryBean.getBindingId()));
            if (!chain.isEmpty()) {
                ResourceManager resourceManager = (ResourceManager)this.getBus().getExtension(ResourceManager.class);
                List resolvers = resourceManager.getResourceResolvers();
                resourceManager = new DefaultResourceManager(resolvers);
                resourceManager.addResourceResolver((ResourceResolver)new WebServiceContextResourceResolver());
                ResourceInjector injector = new ResourceInjector(resourceManager);
                for (Handler h : chain) {
                    if (Proxy.isProxyClass(h.getClass()) && this.getServiceClass() != null) {
                        injector.inject((Object)h, this.getServiceClass());
                        injector.construct((Object)h, this.getServiceClass());
                        continue;
                    }
                    injector.inject((Object)h);
                    injector.construct((Object)h);
                }
            }
            ((JaxWsEndpointImpl)client.getEndpoint()).getJaxwsBinding().setHandlerChain(chain);
        }
    }

    protected void setupClientFactoryBean(ClientFactoryBean factoryBean, Class<?> cls) {
        if (cls != null) {
            factoryBean.setServiceClass(cls);
        }
        factoryBean.setInInterceptors(this.in);
        factoryBean.setOutInterceptors(this.out);
        factoryBean.setOutFaultInterceptors(this.outFault);
        factoryBean.setInFaultInterceptors(this.inFault);
        factoryBean.setFeatures(this.features);
        factoryBean.setTransportId(this.transportId);
        factoryBean.setBindingId(this.bindingId);
        if (this.bindingConfig != null) {
            factoryBean.setBindingConfig(this.bindingConfig);
        }
        if (this.dataBinding != null) {
            factoryBean.setDataBinding(this.dataBinding);
        }
        if (this.serviceFactoryBean != null) {
            this.setServiceFactory(factoryBean, this.serviceFactoryBean);
        }
        factoryBean.setAddress(this.getAddress());
        if (this.getWsdlURL() != null) {
            factoryBean.setWsdlURL(this.getWsdlURL());
        }
        if (this.getServiceName() != null) {
            factoryBean.setServiceName(this.getServiceName());
        }
        if (this.getPortName() != null) {
            factoryBean.setEndpointName(this.getPortName());
        }
        if (this.getDataFormat().dealias() == DataFormat.RAW) {
            RAWDataFormatFeature feature = new RAWDataFormatFeature();
            feature.addInIntercepters(this.getInInterceptors());
            feature.addOutInterceptors(this.getOutInterceptors());
            factoryBean.getFeatures().add(feature);
        } else if (this.getDataFormat().dealias() == DataFormat.CXF_MESSAGE) {
            factoryBean.getFeatures().add(new CXFMessageDataFormatFeature());
            factoryBean.setDataBinding((DataBinding)new SourceDataBinding());
        } else if (this.getDataFormat() == DataFormat.PAYLOAD) {
            factoryBean.getFeatures().add(new PayLoadDataFormatFeature(this.allowStreaming));
            factoryBean.setDataBinding((DataBinding)new HybridSourceDataBinding());
        }
        if (this.isLoggingFeatureEnabled()) {
            if (this.getLoggingSizeLimit() > 0) {
                factoryBean.getFeatures().add(new LoggingFeature(this.getLoggingSizeLimit()));
            } else {
                factoryBean.getFeatures().add(new LoggingFeature());
            }
        }
        if (this.getWrappedStyle() != null) {
            this.setWrapped(factoryBean, this.getWrappedStyle());
        }
        if (this.getProperties() != null) {
            if (factoryBean.getProperties() != null) {
                factoryBean.getProperties().putAll(this.getProperties());
            } else {
                factoryBean.setProperties(this.getProperties());
            }
            LOG.debug("ClientFactoryBean: {} added properties: {}", (Object)factoryBean, this.getProperties());
        }
        if (ObjectHelper.isNotEmpty((Object)this.username)) {
            AuthorizationPolicy authPolicy = new AuthorizationPolicy();
            authPolicy.setUserName(this.username);
            authPolicy.setPassword(this.password);
            factoryBean.getProperties().put(AuthorizationPolicy.class.getName(), authPolicy);
        }
        if (this.isSkipPayloadMessagePartCheck()) {
            if (factoryBean.getProperties() == null) {
                factoryBean.setProperties(new HashMap());
            }
            factoryBean.getProperties().put("soap.no.validate.parts", Boolean.TRUE);
        }
        if (this.isSkipFaultLogging()) {
            if (factoryBean.getProperties() == null) {
                factoryBean.setProperties(new HashMap());
            }
            factoryBean.getProperties().put(FaultListener.class.getName(), new NullFaultListener());
        }
        factoryBean.setBus(this.getBus());
        if (this.getCxfEndpointConfigurer() != null) {
            this.getCxfEndpointConfigurer().configure((AbstractWSDLBasedEndpointFactory)factoryBean);
        }
    }

    private void setWrapped(Object factoryBean, boolean wrapped) {
        try {
            Object sf = factoryBean.getClass().getMethod("getServiceFactory", new Class[0]).invoke(factoryBean, new Object[0]);
            sf.getClass().getMethod("setWrapped", Boolean.TYPE).invoke(sf, wrapped);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private void setServiceFactory(Object factoryBean, Object serviceFactoryBean2) {
        for (Method m : factoryBean.getClass().getMethods()) {
            if (!"setServiceFactory".equals(m.getName()) || !m.getParameterTypes()[0].isInstance(serviceFactoryBean2)) continue;
            try {
                ((Method)ReflectionUtil.setAccessible((AccessibleObject)m)).invoke(factoryBean, serviceFactoryBean2);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    Client createClient() throws Exception {
        if (this.getDataFormat().equals((Object)DataFormat.POJO)) {
            ObjectHelper.notNull(this.getServiceClass(), (String)"serviceClass");
        }
        if (this.getWsdlURL() == null && this.getServiceClass() == null) {
            this.setServiceClass(DefaultSEI.class.getName());
            this.setDefaultOperationNamespace("http://camel.apache.org/cxf/jaxws/dispatch");
            this.setDefaultOperationName("Invoke");
            if (this.getDataFormat().equals((Object)DataFormat.PAYLOAD)) {
                this.setSkipPayloadMessagePartCheck(true);
            }
        }
        Class<?> cls = null;
        if (this.getServiceClass() != null) {
            cls = this.getServiceClass();
            ClientFactoryBean factoryBean = this.createClientFactoryBean(cls);
            this.setupClientFactoryBean(factoryBean, cls);
            Client client = factoryBean.create();
            this.setupHandlers(factoryBean, client);
            return client;
        }
        this.checkName(this.portName, "endpoint/port name");
        this.checkName(this.serviceName, "service name");
        ClientFactoryBean factoryBean = this.createClientFactoryBean();
        this.setupClientFactoryBean(factoryBean, null);
        return factoryBean.create();
    }

    void checkName(Object value, String name) {
        if (ObjectHelper.isEmpty((Object)value)) {
            LOG.warn("The " + name + " of " + this.getEndpointUri() + " is empty, cxf will try to load the first one in wsdl for you.");
        }
    }

    ServerFactoryBean createServerFactoryBean() throws Exception {
        Class<Object> cls = null;
        if (this.getDataFormat() == DataFormat.POJO) {
            ObjectHelper.notNull(this.getServiceClass(), (String)"serviceClass");
        }
        if (this.getWsdlURL() == null && this.getServiceClass() == null && this.getDataFormat().equals((Object)DataFormat.PAYLOAD)) {
            this.setServiceClass(DefaultPayloadProviderSEI.class.getName());
        }
        if (this.getServiceClass() != null) {
            cls = this.getServiceClass();
        }
        Object answer = null;
        if (cls == null) {
            this.checkName(this.portName, " endpoint/port name");
            this.checkName(this.serviceName, " service name");
            answer = new JaxWsServerFactoryBean(new WSDLServiceFactoryBean()){
                {
                    this.doInit = false;
                }
            };
            cls = Provider.class;
        } else {
            answer = CxfEndpointUtils.hasWebServiceAnnotation(cls) ? new JaxWsServerFactoryBean() : new ServerFactoryBean();
        }
        this.setupServerFactoryBean((ServerFactoryBean)answer, cls);
        return answer;
    }

    protected String resolvePropertyPlaceholders(String str) {
        try {
            if (this.getCamelContext() != null) {
                return this.getCamelContext().resolvePropertyPlaceholders(str);
            }
            return str;
        }
        catch (Exception ex) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)ex);
        }
    }

    public String getBeanId() {
        return this.beanId;
    }

    public void setBeanId(String beanId) {
        this.beanId = beanId;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(DataFormat format) {
        this.dataFormat = format;
    }

    public String getPublishedEndpointUrl() {
        return this.resolvePropertyPlaceholders(this.publishedEndpointUrl);
    }

    public void setPublishedEndpointUrl(String url) {
        this.publishedEndpointUrl = url;
    }

    public String getWsdlURL() {
        return this.resolvePropertyPlaceholders(this.wsdlURL);
    }

    public void setWsdlURL(String url) {
        this.wsdlURL = url;
    }

    public Class<?> getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(Class<?> cls) {
        this.serviceClass = cls;
    }

    public void setServiceClass(Object instance) {
        this.serviceClass = ClassHelper.getRealClass((Object)instance);
    }

    public void setServiceClass(String type) throws ClassNotFoundException {
        if (ObjectHelper.isEmpty((Object)type)) {
            throw new IllegalArgumentException("The serviceClass option can neither be null nor an empty String.");
        }
        this.serviceClass = ClassLoaderUtils.loadClass((String)this.resolvePropertyPlaceholders(type), this.getClass());
    }

    public void setServiceNameString(String service) {
        this.serviceNameString = service;
    }

    public void setServiceName(QName service) {
        this.serviceName = service;
    }

    public QName getServiceName() {
        if (this.serviceName == null && this.serviceNameString != null) {
            this.serviceName = QName.valueOf(this.resolvePropertyPlaceholders(this.serviceNameString));
        }
        if (this.serviceName == null && this.getWsdlURL() != null) {
            try {
                Definition definition = ((WSDLManager)this.getBus().getExtension(WSDLManager.class)).getDefinition(this.getWsdlURL());
                if (definition.getServices().size() == 1) {
                    this.serviceName = (QName)definition.getServices().keySet().iterator().next();
                }
            }
            catch (WSDLException e) {
                throw new RuntimeException(e);
            }
        }
        return this.serviceName;
    }

    public QName getPortName() {
        if (this.portName == null && this.portNameString != null) {
            this.portName = QName.valueOf(this.resolvePropertyPlaceholders(this.portNameString));
        }
        return this.portName;
    }

    public void setPortName(QName port) {
        this.portName = port;
    }

    public void setEndpointNameString(String port) {
        this.portNameString = port;
    }

    public void setEndpointName(QName port) {
        this.portName = port;
    }

    public String getDefaultOperationName() {
        return this.resolvePropertyPlaceholders(this.defaultOperationName);
    }

    public void setDefaultOperationName(String name) {
        this.defaultOperationName = name;
    }

    public String getDefaultOperationNamespace() {
        return this.resolvePropertyPlaceholders(this.defaultOperationNamespace);
    }

    public void setDefaultOperationNamespace(String namespace) {
        this.defaultOperationNamespace = namespace;
    }

    public boolean isInOut() {
        return this.inOut;
    }

    public void setInOut(boolean inOut) {
        this.inOut = inOut;
    }

    public boolean isWrapped() {
        return this.isWrapped;
    }

    public void setWrapped(boolean wrapped) {
        this.isWrapped = wrapped;
    }

    public Boolean getWrappedStyle() {
        return this.wrappedStyle;
    }

    public void setWrappedStyle(Boolean wrapped) {
        this.wrappedStyle = wrapped;
    }

    public void setAllowStreaming(Boolean b) {
        this.allowStreaming = b;
    }

    public Boolean getAllowStreaming() {
        return this.allowStreaming;
    }

    public void setCxfBinding(CxfBinding cxfBinding) {
        this.cxfBinding = cxfBinding;
    }

    public CxfBinding getCxfBinding() {
        return this.cxfBinding;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
        if (this.cxfBinding instanceof HeaderFilterStrategyAware) {
            ((HeaderFilterStrategyAware)this.cxfBinding).setHeaderFilterStrategy(headerFilterStrategy);
        }
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
        this.createBus = false;
    }

    public Bus getBus() {
        if (this.bus == null) {
            this.bus = CxfEndpointUtils.createBus(this.getCamelContext());
            this.createBus = true;
            LOG.debug("Using DefaultBus {}", (Object)this.bus);
        }
        if (!this.getBusHasBeenCalled.getAndSet(true) && this.isSetDefaultBus) {
            BusFactory.setDefaultBus((Bus)this.bus);
            LOG.debug("Set bus {} as thread default bus", (Object)this.bus);
        }
        return this.bus;
    }

    public void setSetDefaultBus(boolean isSetDefaultBus) {
        this.isSetDefaultBus = isSetDefaultBus;
    }

    public boolean isSetDefaultBus() {
        return this.isSetDefaultBus;
    }

    public void setLoggingFeatureEnabled(boolean loggingFeatureEnabled) {
        this.loggingFeatureEnabled = loggingFeatureEnabled;
    }

    public boolean isLoggingFeatureEnabled() {
        return this.loggingFeatureEnabled;
    }

    public int getLoggingSizeLimit() {
        return this.loggingSizeLimit;
    }

    public void setLoggingSizeLimit(int loggingSizeLimit) {
        this.loggingSizeLimit = loggingSizeLimit;
    }

    protected boolean isSkipPayloadMessagePartCheck() {
        return this.skipPayloadMessagePartCheck;
    }

    protected void setSkipPayloadMessagePartCheck(boolean skipPayloadMessagePartCheck) {
        this.skipPayloadMessagePartCheck = skipPayloadMessagePartCheck;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setCamelContext(CamelContext c) {
        super.setCamelContext(c);
        if (this.properties != null) {
            try {
                EndpointHelper.setReferenceProperties((CamelContext)this.getCamelContext(), (Object)this, this.properties);
                EndpointHelper.setProperties((CamelContext)this.getCamelContext(), (Object)this, this.properties);
            }
            catch (Throwable e) {
                LOG.warn("Error setting CamelContext. This exception will be ignored.", e);
            }
        }
    }

    public void setProperties(Map<String, Object> properties) {
        if (this.properties == null) {
            this.properties = properties;
        } else {
            this.properties.putAll(properties);
        }
        if (this.getCamelContext() != null && this.properties != null) {
            try {
                EndpointHelper.setReferenceProperties((CamelContext)this.getCamelContext(), (Object)this, this.properties);
                EndpointHelper.setProperties((CamelContext)this.getCamelContext(), (Object)this, this.properties);
            }
            catch (Throwable e) {
                LOG.warn("Error setting properties. This exception will be ignored.", e);
            }
        }
    }

    protected void doStart() throws Exception {
        if (this.headerFilterStrategy == null) {
            this.headerFilterStrategy = new CxfHeaderFilterStrategy();
        }
        if (this.cxfBinding == null) {
            this.cxfBinding = new DefaultCxfBinding();
        }
        if (this.cxfBinding instanceof HeaderFilterStrategyAware) {
            ((HeaderFilterStrategyAware)this.cxfBinding).setHeaderFilterStrategy(this.getHeaderFilterStrategy());
        }
    }

    protected void doStop() throws Exception {
        if (this.createBus && this.bus != null) {
            LOG.info("shutdown the bus ... " + this.bus);
            this.getBus().shutdown(false);
            this.bus = null;
        }
    }

    public void setAddress(String address) {
        super.setEndpointUri(UnsafeUriCharactersEncoder.encodeHttpURI((String)address));
        this.address = address;
    }

    public String getAddress() {
        return this.resolvePropertyPlaceholders(this.address);
    }

    public void setMtomEnabled(boolean mtomEnabled) {
        this.mtomEnabled = mtomEnabled;
    }

    public boolean isMtomEnabled() {
        return this.mtomEnabled;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public List<Interceptor<? extends Message>> getOutFaultInterceptors() {
        return this.outFault;
    }

    public List<Interceptor<? extends Message>> getInFaultInterceptors() {
        return this.inFault;
    }

    public List<Interceptor<? extends Message>> getInInterceptors() {
        return this.in;
    }

    public List<Interceptor<? extends Message>> getOutInterceptors() {
        return this.out;
    }

    public void setInInterceptors(List<Interceptor<? extends Message>> interceptors) {
        this.in = interceptors;
    }

    public void setInFaultInterceptors(List<Interceptor<? extends Message>> interceptors) {
        this.inFault = interceptors;
    }

    public void setOutInterceptors(List<Interceptor<? extends Message>> interceptors) {
        this.out = interceptors;
    }

    public void setOutFaultInterceptors(List<Interceptor<? extends Message>> interceptors) {
        this.outFault = interceptors;
    }

    public void setFeatures(List<Feature> f) {
        this.features = f;
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public void setHandlers(List<Handler> h) {
        this.handlers = h;
    }

    public List<Handler> getHandlers() {
        return this.handlers;
    }

    public void setSchemaLocations(List<String> sc) {
        this.schemaLocations = sc;
    }

    public List<String> getSchemaLocations() {
        return this.schemaLocations;
    }

    public String getTransportId() {
        return this.resolvePropertyPlaceholders(this.transportId);
    }

    public void setTransportId(String transportId) {
        this.transportId = transportId;
    }

    public String getBindingId() {
        return this.resolvePropertyPlaceholders(this.bindingId);
    }

    public void setBindingId(String bindingId) {
        this.bindingId = bindingId;
    }

    public BindingConfiguration getBindingConfig() {
        return this.bindingConfig;
    }

    public boolean isSkipFaultLogging() {
        return this.skipFaultLogging;
    }

    public void setSkipFaultLogging(boolean skipFaultLogging) {
        this.skipFaultLogging = skipFaultLogging;
    }

    public Boolean getMergeProtocolHeaders() {
        return this.mergeProtocolHeaders;
    }

    public void setMergeProtocolHeaders(boolean mergeProtocolHeaders) {
        this.mergeProtocolHeaders = mergeProtocolHeaders;
    }

    public void setBindingConfig(BindingConfiguration bindingConfig) {
        this.bindingConfig = bindingConfig;
    }

    public DataBinding getDataBinding() {
        return this.dataBinding;
    }

    public void setDataBinding(DataBinding dataBinding) {
        this.dataBinding = dataBinding;
    }

    public Object getServiceFactoryBean() {
        return this.serviceFactoryBean;
    }

    public void setServiceFactoryBean(Object serviceFactoryBean) {
        this.serviceFactoryBean = serviceFactoryBean;
    }

    public CxfEndpointConfigurer getCxfEndpointConfigurer() {
        return this.configurer;
    }

    public void setCxfEndpointConfigurer(CxfEndpointConfigurer configurer) {
        this.configurer = configurer;
    }

    public long getContinuationTimeout() {
        return this.continuationTimeout;
    }

    public void setContinuationTimeout(long continuationTimeout) {
        this.continuationTimeout = continuationTimeout;
    }

    class CamelCxfClientImpl
    extends ClientImpl {
        public CamelCxfClientImpl(Bus bus, Endpoint ep) {
            super(bus, ep);
        }

        public Bus getBus() {
            return this.bus;
        }

        protected void setParameters(Object[] params, Message message) {
            Object attachments = message.get((Object)"CamelAttachments");
            if (attachments != null) {
                message.setAttachments((Collection)attachments);
                message.remove((Object)"CamelAttachments");
            }
            if (DataFormat.PAYLOAD == message.get(DataFormat.class) && params[0] instanceof CxfPayload) {
                CxfPayload payload = (CxfPayload)params[0];
                List<Source> elements = payload.getBodySources();
                BindingOperationInfo boi = (BindingOperationInfo)message.get(BindingOperationInfo.class);
                MessageContentsList content = new MessageContentsList();
                int i = 0;
                for (MessagePartInfo partInfo : boi.getInput().getMessageParts()) {
                    if (elements.size() <= i) continue;
                    if (CxfEndpoint.this.isSkipPayloadMessagePartCheck()) {
                        content.put(partInfo, (Object)elements.get(i++));
                        continue;
                    }
                    String name = this.findName(elements, i);
                    if (!partInfo.getConcreteName().getLocalPart().equals(name)) continue;
                    content.put(partInfo, (Object)elements.get(i++));
                }
                if (elements != null && content.size() < elements.size()) {
                    throw new IllegalArgumentException("The PayLoad elements cannot fit with the message parts of the BindingOperation. Please check the BindingOperation and PayLoadMessage.");
                }
                message.setContent(List.class, (Object)content);
                message.put((Object)Header.HEADER_LIST, payload.getHeaders());
            } else {
                super.setParameters(params, message);
            }
            message.remove(DataFormat.class);
        }

        private String findName(List<Source> sources, int i) {
            Object s;
            Source source = sources.get(i);
            XMLStreamReader r = null;
            if (source instanceof DOMSource) {
                Node nd = ((DOMSource)source).getNode();
                if (nd instanceof Document) {
                    nd = ((Document)nd).getDocumentElement();
                }
                return ((Element)nd).getLocalName();
            }
            if (source instanceof StaxSource) {
                s = (StaxSource)source;
                r = s.getXMLStreamReader();
            } else if (source instanceof StAXSource) {
                s = (StAXSource)source;
                r = ((StAXSource)s).getXMLStreamReader();
            } else if (source instanceof StreamSource || source instanceof SAXSource) {
                r = StaxUtils.createXMLStreamReader((Source)source);
                StaxSource src2 = new StaxSource(r);
                sources.set(i, (Source)src2);
            }
            if (r != null) {
                try {
                    if (r.getEventType() == 7) {
                        r.next();
                    }
                    if (r.getEventType() != 1) {
                        r.nextTag();
                    }
                }
                catch (XMLStreamException e) {
                    LOG.warn("Error finding the start element.", (Throwable)e);
                    return null;
                }
                return r.getLocalName();
            }
            return null;
        }
    }
}

