/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.validate.xml.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.switchyard.common.type.Classes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlValidatorDTDResolver
implements EntityResolver {
    private List<String> _schemaFileNames = new ArrayList<String>();

    public XmlValidatorDTDResolver() {
    }

    public XmlValidatorDTDResolver(List<String> schemaFileNames) {
        this();
        if (schemaFileNames != null) {
            for (String fem : schemaFileNames) {
                this._schemaFileNames.add(fem);
            }
        }
    }

    protected URL locateFile(String path) throws IOException {
        if (path == null) {
            return null;
        }
        if (new File(path).exists()) {
            try {
                return new File(path).toURI().toURL();
            }
            catch (Exception e) {
                return null;
            }
        }
        URL res = Classes.getResource((String)path);
        if (res != null) {
            return res;
        }
        return null;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (this._schemaFileNames != null) {
            for (String validatorFileName : this._schemaFileNames) {
                URL temp;
                URL url = null;
                url = this.locateFile(systemId);
                if (url == null && (temp = new URL(systemId)).getProtocol().equals("file")) {
                    URL res;
                    File systemFile = new File(systemId);
                    String systemFileName = systemFile.getName();
                    File localFile = new File(validatorFileName);
                    if (localFile.getParentFile() == null && systemFileName.equals(validatorFileName) && (res = Classes.getResource((String)validatorFileName)) != null) {
                        return new InputSource(res.openStream());
                    }
                }
                if (url == null) continue;
                return new InputSource(url.openStream());
            }
        }
        return null;
    }
}

