/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension;

import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.switchyard.as7.extension.Attribute;
import org.switchyard.as7.extension.Element;
import org.switchyard.as7.extension.ExtensionMessages;
import org.switchyard.as7.extension.SwitchYardExtension;

final class SwitchYardSubsystemReader
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>> {
    private static final SwitchYardSubsystemReader INSTANCE = new SwitchYardSubsystemReader();

    private SwitchYardSubsystemReader() {
    }

    static SwitchYardSubsystemReader getInstance() {
        return INSTANCE;
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ModelNode subsystem = SwitchYardExtension.createAddSubsystemOperation();
        list.add(subsystem);
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            if (!reader.getNamespaceURI().equals("urn:jboss:domain:switchyard:1.0")) continue;
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SOCKET_BINDING: {
                    String sockets = null;
                    int count = reader.getAttributeCount();
                    block11: for (int i = 0; i < count; ++i) {
                        ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                        Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case NAMES: {
                                sockets = reader.getAttributeValue(i);
                                continue block11;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                            }
                        }
                    }
                    if (sockets != null) {
                        subsystem.get("socket-binding").set(sockets);
                    }
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block10;
                }
                case SECURITY_CONFIGS: {
                    this.parseSecurityConfigsElement(reader, list);
                    continue block10;
                }
                case MODULES: {
                    this.parseModulesElement(reader, list);
                    continue block10;
                }
                case EXTENSIONS: {
                    this.parseExtensionsElement(reader, list);
                    continue block10;
                }
                case PROPERTIES: {
                    ModelNode properties = this.parsePropertiesElement("", reader);
                    if (properties == null) continue block10;
                    subsystem.get("properties").set(properties);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void parseSecurityConfigsElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        while (reader.hasNext() && reader.nextTag() != 2) {
            if (!reader.getNamespaceURI().equals("urn:jboss:domain:switchyard:1.0")) continue;
            Element element = Element.forName(reader.getLocalName());
            if (element == Element.SECURITY_CONFIG) {
                this.parseSecurityConfigElement(reader, list);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void parseSecurityConfigElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        String identifier = null;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case IDENTIFIER: {
                    identifier = reader.getAttributeValue(i);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (identifier == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.IDENTIFIER));
        }
        ModelNode securityConfigAdd = new ModelNode();
        securityConfigAdd.get("operation").set("add");
        PathAddress addr = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"switchyard"), PathElement.pathElement((String)"security-config", (String)identifier)});
        securityConfigAdd.get("address").set(addr.toModelNode());
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element1 = Element.forName(reader.getLocalName());
            switch (element1) {
                case PROPERTIES: {
                    ModelNode properties = this.parsePropertiesElement(identifier, reader);
                    if (properties == null) continue block7;
                    securityConfigAdd.get("properties").set(properties);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        list.add(securityConfigAdd);
    }

    void parseModulesElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        while (reader.hasNext() && reader.nextTag() != 2) {
            if (!reader.getNamespaceURI().equals("urn:jboss:domain:switchyard:1.0")) continue;
            Element element = Element.forName(reader.getLocalName());
            if (element == Element.MODULE) {
                this.parseModuleElement(reader, list);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void parseModuleElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        String identifier = null;
        String implClass = null;
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case IDENTIFIER: {
                    identifier = reader.getAttributeValue(i);
                    continue block7;
                }
                case IMPLCLASS: {
                    implClass = reader.getAttributeValue(i);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (identifier == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.IDENTIFIER));
        }
        if (implClass == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.IMPLCLASS));
        }
        ModelNode moduleAdd = new ModelNode();
        moduleAdd.get("operation").set("add");
        PathAddress addr = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"switchyard"), PathElement.pathElement((String)"module", (String)identifier)});
        moduleAdd.get("address").set(addr.toModelNode());
        moduleAdd.get("implClass").set(implClass);
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element1 = Element.forName(reader.getLocalName());
            switch (element1) {
                case PROPERTIES: {
                    ModelNode properties = this.parsePropertiesElement(identifier, reader);
                    if (properties == null) continue block8;
                    moduleAdd.get("properties").set(properties);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        list.add(moduleAdd);
    }

    ModelNode parsePropertiesElement(String identifier, XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ModelNode properties = new ModelNode();
        StringBuffer configModel = new StringBuffer();
        while (reader.hasNext() && reader.nextTag() != 2) {
            if (!reader.getNamespaceURI().equals("urn:jboss:domain:switchyard:1.0")) continue;
            Element element = Element.forName(reader.getLocalName());
            String name = reader.getLocalName();
            String value = reader.getElementText();
            if (properties.has(name)) {
                throw ExtensionMessages.MESSAGES.alreadyDeclared(element.getLocalName(), reader.getLocation().toString());
            }
            ModelNode property = new ModelNode();
            property.set(value);
            properties.get(name).set(property);
            configModel.append(element.toString());
        }
        return properties;
    }

    void parseExtensionsElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        while (reader.hasNext() && reader.nextTag() != 2) {
            if (!reader.getNamespaceURI().equals("urn:jboss:domain:switchyard:1.0")) continue;
            Element element = Element.forName(reader.getLocalName());
            if (element == Element.EXTENSION) {
                this.parseExtensionElement(reader, list);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void parseExtensionElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        String identifier = null;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case IDENTIFIER: {
                    identifier = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (identifier == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.IDENTIFIER));
        }
        ModelNode moduleAdd = new ModelNode();
        moduleAdd.get("operation").set("add");
        PathAddress addr = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"switchyard"), PathElement.pathElement((String)"extension", (String)identifier)});
        moduleAdd.get("address").set(addr.toModelNode());
        if (reader.hasNext() && reader.nextTag() != 2) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        list.add(moduleAdd);
    }
}

