/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension;

import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.switchyard.as7.extension.Attribute;
import org.switchyard.as7.extension.Element;

final class SwitchYardSubsystemWriter
implements XMLElementWriter<SubsystemMarshallingContext> {
    private static final SwitchYardSubsystemWriter INSTANCE = new SwitchYardSubsystemWriter();

    private SwitchYardSubsystemWriter() {
    }

    static SwitchYardSubsystemWriter getInstance() {
        return INSTANCE;
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        ModelNode entry;
        ModelNode modules;
        context.startSubsystemElement("urn:jboss:domain:switchyard:1.0", false);
        ModelNode node = context.getModelNode();
        if (node.hasDefined("socket-binding")) {
            ModelNode socketNames = node.get("socket-binding");
            writer.writeEmptyElement(Element.SOCKET_BINDING.getLocalName());
            writer.writeAttribute(Attribute.NAMES.getLocalName(), socketNames.asString());
        }
        if (node.hasDefined("security-config")) {
            modules = node.get("security-config");
            writer.writeStartElement(Element.SECURITY_CONFIGS.getLocalName());
            for (Property property : modules.asPropertyList()) {
                writer.writeStartElement(Element.SECURITY_CONFIG.getLocalName());
                writer.writeAttribute(Attribute.IDENTIFIER.getLocalName(), property.getName());
                entry = property.getValue();
                SwitchYardSubsystemWriter.writeProperties(entry, writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (node.hasDefined("module")) {
            modules = node.get("module");
            writer.writeStartElement(Element.MODULES.getLocalName());
            for (Property property : modules.asPropertyList()) {
                writer.writeStartElement(Element.MODULE.getLocalName());
                writer.writeAttribute(Attribute.IDENTIFIER.getLocalName(), property.getName());
                entry = property.getValue();
                if (entry.hasDefined("implClass")) {
                    writer.writeAttribute(Attribute.IMPLCLASS.getLocalName(), entry.get("implClass").asString());
                }
                SwitchYardSubsystemWriter.writeProperties(entry, writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (node.hasDefined("extension")) {
            modules = node.get("extension");
            writer.writeStartElement(Element.EXTENSIONS.getLocalName());
            for (Property property : modules.asPropertyList()) {
                writer.writeStartElement(Element.EXTENSION.getLocalName());
                writer.writeAttribute(Attribute.IDENTIFIER.getLocalName(), property.getName());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        SwitchYardSubsystemWriter.writeProperties(node, writer);
        writer.writeEndElement();
    }

    private static void writeProperties(ModelNode node, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (node.hasDefined("properties")) {
            ModelNode properties = node.get("properties");
            writer.writeStartElement(Element.PROPERTIES.getLocalName());
            Set keys = properties.keys();
            for (String current : keys) {
                writer.writeStartElement(current);
                writer.writeCharacters(properties.get(current).asString());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }
}

