/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.admin.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.switchyard.admin.Component;
import org.switchyard.admin.ComponentReference;
import org.switchyard.admin.ComponentService;

public class BaseComponent
implements Component {
    private final QName _name;
    private final String _type;
    private final ComponentService _service;
    private final Map<QName, ComponentReference> _references;
    private final Map<String, String> _properties;

    public BaseComponent(QName name, String type, ComponentService service, Map<QName, ComponentReference> references, Map<String, String> properties) {
        this._name = name;
        this._type = type;
        this._service = service;
        this._references = references;
        this._properties = properties;
    }

    @Override
    public Map<String, String> getProperties() {
        return this._properties;
    }

    @Override
    public QName getName() {
        return this._name;
    }

    @Override
    public String getType() {
        return this._type;
    }

    @Override
    public ComponentService getService() {
        return this._service;
    }

    @Override
    public List<ComponentReference> getReferences() {
        if (this._references == null) {
            return Collections.emptyList();
        }
        return new ArrayList<ComponentReference>(this._references.values());
    }

    @Override
    public ComponentReference getReference(QName componentReferenceName) {
        if (this._references == null) {
            return null;
        }
        return this._references.get(componentReferenceName);
    }
}

