/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.admin.base;

import java.util.EventObject;
import javax.xml.namespace.QName;
import org.switchyard.Exchange;
import org.switchyard.admin.SwitchYard;
import org.switchyard.admin.base.BaseApplication;
import org.switchyard.admin.base.BaseSwitchYard;
import org.switchyard.admin.mbean.internal.LocalManagement;
import org.switchyard.admin.mbean.internal.MBeans;
import org.switchyard.deploy.ComponentNames;
import org.switchyard.deploy.ServiceDomainManager;
import org.switchyard.deploy.event.ApplicationDeployedEvent;
import org.switchyard.deploy.event.ApplicationUndeployedEvent;
import org.switchyard.deploy.internal.AbstractDeployment;
import org.switchyard.event.EventObserver;
import org.switchyard.runtime.event.ExchangeCompletionEvent;

public class SwitchYardBuilder
implements EventObserver {
    private BaseSwitchYard _switchYard = new BaseSwitchYard();
    private ServiceDomainManager _domainManager;

    public void init(ServiceDomainManager domainManager) {
        this._domainManager = domainManager;
        LocalManagement lm = new LocalManagement(this._domainManager);
        MBeans.registerLocalManagement(lm);
        this._domainManager.getEventManager().addObserver((EventObserver)this, ExchangeCompletionEvent.class).addObserver((EventObserver)this, ApplicationDeployedEvent.class).addObserver((EventObserver)this, ApplicationUndeployedEvent.class);
    }

    public void destroy() {
        this._domainManager.getEventManager().removeObserver((EventObserver)this);
        MBeans.unregisterLocalManagement();
    }

    public SwitchYard getSwitchYard() {
        return this._switchYard;
    }

    public ServiceDomainManager getDomainManager() {
        return this._domainManager;
    }

    public void notify(EventObject event) {
        if (event instanceof ApplicationDeployedEvent) {
            this.applicationDeployed((ApplicationDeployedEvent)event);
        } else if (event instanceof ApplicationUndeployedEvent) {
            this.applicationUndeployed((ApplicationUndeployedEvent)event);
        } else if (event instanceof ExchangeCompletionEvent) {
            this.exchangeCompleted((ExchangeCompletionEvent)event);
        }
    }

    void applicationDeployed(ApplicationDeployedEvent event) {
        AbstractDeployment deployment = event.getDeployment();
        if (deployment.getName() != null) {
            BaseApplication app = new BaseApplication(deployment);
            this._switchYard.addApplication(app);
            MBeans.registerApplication(app);
        }
    }

    void applicationUndeployed(ApplicationUndeployedEvent event) {
        BaseApplication app;
        AbstractDeployment deployment = event.getDeployment();
        if (deployment.getName() != null && (app = (BaseApplication)this._switchYard.getApplication(deployment.getName())) != null) {
            MBeans.unregisterApplication(app);
            this._switchYard.removeApplication(deployment.getName());
            app.dispose();
        }
    }

    void exchangeCompleted(ExchangeCompletionEvent event) {
        Exchange exchange = event.getExchange();
        QName componentName = ComponentNames.componentName((QName)exchange.getConsumer().getName());
        if (componentName == null) {
            this._switchYard.recordMetrics(exchange);
        }
    }
}

