/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.rss.model.v2;

import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.switchyard.component.camel.common.QueryString;
import org.switchyard.component.camel.common.model.consumer.CamelScheduledPollConsumer;
import org.switchyard.component.camel.common.model.v1.V1BaseCamelBindingModel;
import org.switchyard.component.camel.common.model.v1.V1CamelScheduledPollConsumer;
import org.switchyard.component.camel.rss.model.CamelRSSBindingModel;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.Model;

public class V2CamelRSSBindingModel
extends V1BaseCamelBindingModel
implements CamelRSSBindingModel {
    public static final String RSS = "rss";
    private static final String FEED_URI = "feedURI";
    private static final String SPLIT_ENTRIES = "splitEntries";
    private static final String FILTER = "filter";
    private static final String LAST_UPDATE = "lastUpdate";
    private static final String THROTTLE_ENTRIES = "throttleEntries";
    private static final String FEED_HEADER = "feedHeader";
    private static final String SORT_ENTRIES = "sortEntries";
    private CamelScheduledPollConsumer _consume;
    private static final String DATE_FORMAT_STRING = "yyyy-MM-dd'T'HH:mm:ss";

    public V2CamelRSSBindingModel(String namespace) {
        super(RSS, namespace);
        this.setModelChildrenOrder(new String[]{FEED_URI, SPLIT_ENTRIES, FILTER, LAST_UPDATE, THROTTLE_ENTRIES, FEED_HEADER, SORT_ENTRIES, "consume"});
    }

    public V2CamelRSSBindingModel(Configuration config, Descriptor desc) {
        super(config, desc);
    }

    @Override
    public URI getFeedURI() {
        String uriStr = this.getConfig(FEED_URI);
        if (uriStr != null) {
            return URI.create(uriStr);
        }
        return null;
    }

    @Override
    public V2CamelRSSBindingModel setFeedURI(URI uri) {
        return (V2CamelRSSBindingModel)this.setConfig(FEED_URI, uri.toString());
    }

    @Override
    public Date getLastUpdate() {
        SimpleDateFormat lastUpdateDateFormat = new SimpleDateFormat(DATE_FORMAT_STRING);
        return this.getDateConfig(LAST_UPDATE, lastUpdateDateFormat);
    }

    @Override
    public V2CamelRSSBindingModel setLastUpdate(Date date) {
        SimpleDateFormat lastUpdateDateFormat = new SimpleDateFormat(DATE_FORMAT_STRING);
        this.setConfig(LAST_UPDATE, lastUpdateDateFormat.format(date));
        return this;
    }

    @Override
    public Boolean isFeedHeader() {
        return this.getBooleanConfig(FEED_HEADER);
    }

    @Override
    public V2CamelRSSBindingModel setFeedHeader(Boolean feedHeader) {
        return (V2CamelRSSBindingModel)this.setConfig(FEED_HEADER, feedHeader);
    }

    @Override
    public Boolean isFilter() {
        return this.getBooleanConfig(FILTER);
    }

    @Override
    public V2CamelRSSBindingModel setFilter(Boolean filtered) {
        return (V2CamelRSSBindingModel)this.setConfig(FILTER, filtered);
    }

    @Override
    public Boolean isSortEntries() {
        return this.getBooleanConfig(SORT_ENTRIES);
    }

    @Override
    public V2CamelRSSBindingModel setSortEntries(Boolean sorted) {
        return (V2CamelRSSBindingModel)this.setConfig(SORT_ENTRIES, sorted);
    }

    @Override
    public Boolean isSplitEntries() {
        return this.getBooleanConfig(SPLIT_ENTRIES);
    }

    @Override
    public V2CamelRSSBindingModel setSplitEntries(Boolean split) {
        return (V2CamelRSSBindingModel)this.setConfig(SPLIT_ENTRIES, String.valueOf(split));
    }

    @Override
    public Boolean isThrottleEntries() {
        return this.getBooleanConfig(THROTTLE_ENTRIES);
    }

    @Override
    public V2CamelRSSBindingModel setThrottleEntries(Boolean throttled) {
        return (V2CamelRSSBindingModel)this.setConfig(THROTTLE_ENTRIES, String.valueOf(throttled));
    }

    @Override
    public CamelScheduledPollConsumer getConsumer() {
        if (this._consume == null) {
            Configuration config = this.getModelConfiguration().getFirstChild("consume");
            this._consume = new V1CamelScheduledPollConsumer(config, this.getModelDescriptor());
        }
        return this._consume;
    }

    @Override
    public V2CamelRSSBindingModel setConsumer(CamelScheduledPollConsumer consumer) {
        Configuration config = this.getModelConfiguration().getFirstChild("consume");
        if (config != null) {
            this.getModelConfiguration().removeChildren("consume");
            this.getModelConfiguration().addChild(((V1CamelScheduledPollConsumer)consumer).getModelConfiguration());
        } else {
            this.setChildModel((Model)((V1CamelScheduledPollConsumer)consumer));
        }
        this._consume = consumer;
        return this;
    }

    public URI getComponentURI() {
        Configuration modelConfiguration = this.getModelConfiguration();
        List children = modelConfiguration.getChildren();
        String baseUri = "rss://" + this.getFeedURI();
        QueryString queryStr = new QueryString();
        this.traverseConfiguration(children, queryStr, new String[]{FEED_URI});
        return URI.create(baseUri + queryStr.toString());
    }
}

