/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.invocation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collection;
import javax.management.MBeanException;
import javax.xml.ws.soap.SOAPFaultException;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.webservices.WSMessages;
import org.jboss.as.webservices.metadata.model.AbstractEndpoint;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.invocation.InterceptorContext;
import org.jboss.msc.service.ServiceName;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.Invocation;

abstract class AbstractInvocationHandler
extends org.jboss.ws.common.invocation.AbstractInvocationHandler {
    private ServiceName componentViewName;
    private volatile ComponentView componentView;
    protected volatile ManagedReference reference;

    AbstractInvocationHandler() {
    }

    public void init(Endpoint endpoint) {
        this.componentViewName = (ServiceName)endpoint.getProperty(AbstractEndpoint.COMPONENT_VIEW_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ComponentView getComponentView() {
        if (this.componentView == null || this.reference == null) {
            AbstractInvocationHandler abstractInvocationHandler = this;
            synchronized (abstractInvocationHandler) {
                if (this.componentView == null) {
                    this.componentView = ASHelper.getMSCService(this.componentViewName, ComponentView.class);
                    if (this.componentView == null) {
                        throw WSMessages.MESSAGES.cannotFindComponentView(this.componentViewName);
                    }
                    try {
                        this.reference = this.componentView.createInstance();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return this.componentView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Endpoint endpoint, Invocation wsInvocation) throws Exception {
        try {
            this.onBeforeInvocation(wsInvocation);
            ComponentView componentView = this.getComponentView();
            Method method = this.getComponentViewMethod(wsInvocation.getJavaMethod(), componentView.getViewMethods());
            InterceptorContext context = new InterceptorContext();
            this.prepareForInvocation(context, wsInvocation);
            context.setMethod(method);
            context.setParameters(wsInvocation.getArgs());
            context.setTarget(this.reference.getInstance());
            context.putPrivateData(Component.class, (Object)componentView.getComponent());
            context.putPrivateData(ComponentView.class, (Object)componentView);
            Object retObj = componentView.invoke(context);
            wsInvocation.setReturnValue(retObj);
        }
        catch (Throwable t) {
            this.log.error((Object)WSMessages.MESSAGES.methodInvocationFailed(t.getLocalizedMessage()), t);
            this.handleInvocationException(t);
        }
        finally {
            this.onAfterInvocation(wsInvocation);
        }
    }

    protected void prepareForInvocation(InterceptorContext context, Invocation wsInvocation) {
    }

    protected Method getComponentViewMethod(Method seiMethod, Collection<Method> viewMethods) {
        for (Method viewMethod : viewMethods) {
            if (!this.matches(seiMethod, viewMethod)) continue;
            return viewMethod;
        }
        throw new IllegalStateException();
    }

    protected void handleInvocationException(Throwable t) throws Exception {
        if (t instanceof MBeanException) {
            throw ((MBeanException)t).getTargetException();
        }
        if (t instanceof Exception) {
            if (t instanceof InvocationTargetException) {
                throw (Exception)t;
            }
            SOAPFaultException ex = this.findSoapFaultException(t);
            if (ex != null) {
                throw new InvocationTargetException((Throwable)ex);
            }
            throw new InvocationTargetException(t);
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new UndeclaredThrowableException(t);
    }

    protected SOAPFaultException findSoapFaultException(Throwable ex) {
        if (ex instanceof SOAPFaultException) {
            return (SOAPFaultException)ex;
        }
        if (ex.getCause() != null) {
            return this.findSoapFaultException(ex.getCause());
        }
        return null;
    }

    private boolean matches(Method seiMethod, Method viewMethod) {
        Class<?>[] targetParams;
        if (!seiMethod.getName().equals(viewMethod.getName())) {
            return false;
        }
        Class<?>[] sourceParams = seiMethod.getParameterTypes();
        if (sourceParams.length != (targetParams = viewMethod.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < sourceParams.length; ++i) {
            if (sourceParams[i].equals(targetParams[i])) continue;
            return false;
        }
        return true;
    }
}

