/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.mqtt.model.v2;

import java.net.URI;
import java.util.List;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.switchyard.component.camel.common.QueryString;
import org.switchyard.component.camel.common.model.v1.V1BaseCamelBindingModel;
import org.switchyard.component.camel.mqtt.model.CamelMqttBindingModel;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.Descriptor;

public class V2CamelMqttBindingModel
extends V1BaseCamelBindingModel
implements CamelMqttBindingModel {
    private static final String NAME = "name";
    private static final String HOST = "host";
    private static final String LOCAL_ADDRESS = "localAddress";
    private static final String CONNECT_ATTEMPTS_MAX = "connectAttemptsMax";
    private static final String RECONNECT_ATTEMPTS_MAX = "reconnectAttemptsMax";
    private static final String RECONNECT_DELAY = "reconnectDelay";
    private static final String RECONNECT_BACK_OFF_MULTIPLIER = "reconnectBackOffMultiplier";
    private static final String RECONNECT_DELAY_MAX = "reconnectDelayMax";
    private static final String USER_NAME = "userName";
    private static final String PASSWORD = "password";
    private static final String QUALITY_OF_SERVICE = "qualityOfService";
    private static final String SUBSCRIBE_TOPIC_NAME = "subscribeTopicName";
    private static final String PUBLISH_TOPIC_NAME = "publishTopicName";
    private static final String BY_DEFAULT_RETAIN = "byDefaultRetain";
    private static final String MQTT_TOPIC_PROPERTY_NAME = "mqttTopicPropertyName";
    private static final String MQTT_RETAIN_PROPERTY_NAME = "mqttRetainPropertyName";
    private static final String MQTT_QOS_PROPERTY_NAME = "mqttQosPropertyName";
    private static final String CONNECT_WAIT_IN_SECONDS = "connectWaitInSeconds";
    private static final String DISCONNECT_WAIT_IN_SECONDS = "disconnectWaitInSeconds";
    private static final String SEND_WAIT_IN_SECONDS = "sendWaitInSeconds";

    public V2CamelMqttBindingModel(Configuration config, Descriptor desc) {
        super(config, desc);
    }

    public V2CamelMqttBindingModel(String namespace) {
        super("mqtt", namespace);
        this.setModelChildrenOrder(new String[]{NAME, HOST, LOCAL_ADDRESS, CONNECT_ATTEMPTS_MAX, RECONNECT_ATTEMPTS_MAX, RECONNECT_DELAY, RECONNECT_BACK_OFF_MULTIPLIER, RECONNECT_DELAY_MAX, USER_NAME, PASSWORD, QUALITY_OF_SERVICE, SUBSCRIBE_TOPIC_NAME, PUBLISH_TOPIC_NAME, BY_DEFAULT_RETAIN, MQTT_TOPIC_PROPERTY_NAME, MQTT_RETAIN_PROPERTY_NAME, MQTT_QOS_PROPERTY_NAME, CONNECT_WAIT_IN_SECONDS, DISCONNECT_WAIT_IN_SECONDS, SEND_WAIT_IN_SECONDS});
    }

    @Override
    public String getName() {
        return this.getModelAttribute(NAME);
    }

    @Override
    public V2CamelMqttBindingModel setName(String name) {
        this.setModelAttribute(NAME, name);
        return this;
    }

    @Override
    public String getHost() {
        return this.getConfig(HOST);
    }

    @Override
    public V2CamelMqttBindingModel setHost(String host) {
        return (V2CamelMqttBindingModel)this.setConfig(HOST, host);
    }

    @Override
    public String getLocalAddress() {
        return this.getConfig(LOCAL_ADDRESS);
    }

    @Override
    public V2CamelMqttBindingModel setLocalAddress(String localAddress) {
        return (V2CamelMqttBindingModel)this.setConfig(LOCAL_ADDRESS, localAddress);
    }

    @Override
    public Integer getConnectAttemptsMax() {
        return this.getIntegerConfig(CONNECT_ATTEMPTS_MAX);
    }

    @Override
    public V2CamelMqttBindingModel setConnectAttemptsMax(int connectAttemptsMax) {
        return (V2CamelMqttBindingModel)this.setConfig(CONNECT_ATTEMPTS_MAX, connectAttemptsMax);
    }

    @Override
    public Integer getReconnectAttemptsMax() {
        return this.getIntegerConfig(RECONNECT_ATTEMPTS_MAX);
    }

    @Override
    public V2CamelMqttBindingModel setReconnectAttemptsMax(int reconnectAttemptsMax) {
        return (V2CamelMqttBindingModel)this.setConfig(RECONNECT_ATTEMPTS_MAX, reconnectAttemptsMax);
    }

    @Override
    public Integer getReconnectDelay() {
        return this.getIntegerConfig(RECONNECT_DELAY);
    }

    @Override
    public V2CamelMqttBindingModel setReconnectDelay(int reconnectDelay) {
        return (V2CamelMqttBindingModel)this.setConfig(RECONNECT_DELAY, reconnectDelay);
    }

    @Override
    public Double getReconnectBackOffMultiplier() {
        return this.getDoubleConfig(RECONNECT_BACK_OFF_MULTIPLIER);
    }

    @Override
    public V2CamelMqttBindingModel setReconnectBackOffMultiplier(double reconnectBackOffMultiplier) {
        return (V2CamelMqttBindingModel)this.setConfig(RECONNECT_BACK_OFF_MULTIPLIER, reconnectBackOffMultiplier);
    }

    @Override
    public Integer getReconnectDelayMax() {
        return this.getIntegerConfig(RECONNECT_DELAY_MAX);
    }

    @Override
    public V2CamelMqttBindingModel setReconnectDelayMax(int reconnectDelayMax) {
        return (V2CamelMqttBindingModel)this.setConfig(RECONNECT_DELAY_MAX, reconnectDelayMax);
    }

    @Override
    public String getUserName() {
        return this.getConfig(USER_NAME);
    }

    @Override
    public V2CamelMqttBindingModel setUserName(String username) {
        return (V2CamelMqttBindingModel)this.setConfig(USER_NAME, username);
    }

    @Override
    public String getPassword() {
        return this.getConfig(PASSWORD);
    }

    @Override
    public V2CamelMqttBindingModel setPassword(String password) {
        return (V2CamelMqttBindingModel)this.setConfig(PASSWORD, password);
    }

    @Override
    public String getQualityOfService() {
        QualityOfService qualityOfService = this.getModelConfiguration() != null ? QualityOfService.valueOf(this.getConfig(QUALITY_OF_SERVICE)) : QualityOfService.AtLeastOnce;
        return qualityOfService.name();
    }

    @Override
    public V2CamelMqttBindingModel setQualityOfService(String qualityOfService) {
        return (V2CamelMqttBindingModel)this.setConfig(QUALITY_OF_SERVICE, qualityOfService);
    }

    @Override
    public String getSubscribeTopicName() {
        return this.getConfig(SUBSCRIBE_TOPIC_NAME);
    }

    @Override
    public V2CamelMqttBindingModel setSubscribeTopicName(String subscribeTopicName) {
        return (V2CamelMqttBindingModel)this.setConfig(SUBSCRIBE_TOPIC_NAME, subscribeTopicName);
    }

    @Override
    public String getPublishTopicName() {
        return this.getConfig(PUBLISH_TOPIC_NAME);
    }

    @Override
    public V2CamelMqttBindingModel setPublishTopicName(String publishTopicName) {
        return (V2CamelMqttBindingModel)this.setConfig(PUBLISH_TOPIC_NAME, publishTopicName);
    }

    @Override
    public Boolean isByDefaultRetain() {
        return this.getBooleanConfig(BY_DEFAULT_RETAIN);
    }

    @Override
    public V2CamelMqttBindingModel setByDefaultRetain(Boolean byDefaultRetain) {
        return (V2CamelMqttBindingModel)this.setConfig(BY_DEFAULT_RETAIN, byDefaultRetain);
    }

    @Override
    public String getMqttTopicPropertyName() {
        return this.getConfig(MQTT_TOPIC_PROPERTY_NAME);
    }

    @Override
    public V2CamelMqttBindingModel setMqttTopicPropertyName(String mqttTopicPropertyName) {
        return (V2CamelMqttBindingModel)this.setConfig(MQTT_TOPIC_PROPERTY_NAME, mqttTopicPropertyName);
    }

    @Override
    public String getMqttRetainPropertyName() {
        return this.getConfig(MQTT_RETAIN_PROPERTY_NAME);
    }

    @Override
    public V2CamelMqttBindingModel setMqttRetainPropertyName(String mqttRetainPropertyName) {
        return (V2CamelMqttBindingModel)this.setConfig(MQTT_RETAIN_PROPERTY_NAME, mqttRetainPropertyName);
    }

    @Override
    public String getMqttQosPropertyName() {
        return this.getConfig(MQTT_QOS_PROPERTY_NAME);
    }

    @Override
    public V2CamelMqttBindingModel setMqttQosPropertyName(String mqttQosPropertyName) {
        return (V2CamelMqttBindingModel)this.setConfig(MQTT_QOS_PROPERTY_NAME, mqttQosPropertyName);
    }

    @Override
    public Integer getConnectWaitInSeconds() {
        return this.getIntegerConfig(CONNECT_WAIT_IN_SECONDS);
    }

    @Override
    public V2CamelMqttBindingModel setConnectWaitInSeconds(int connectWaitInSeconds) {
        return (V2CamelMqttBindingModel)this.setConfig(CONNECT_WAIT_IN_SECONDS, connectWaitInSeconds);
    }

    @Override
    public Integer getDisconnectWaitInSeconds() {
        return this.getIntegerConfig(DISCONNECT_WAIT_IN_SECONDS);
    }

    @Override
    public V2CamelMqttBindingModel setDisonnectWaitInSeconds(int disconnectWaitInSeconds) {
        return (V2CamelMqttBindingModel)this.setConfig(DISCONNECT_WAIT_IN_SECONDS, disconnectWaitInSeconds);
    }

    @Override
    public Integer getSendWaitInSeconds() {
        return this.getIntegerConfig(SEND_WAIT_IN_SECONDS);
    }

    @Override
    public V2CamelMqttBindingModel setSendWaitInSeconds(int sendWaitInSeconds) {
        return (V2CamelMqttBindingModel)this.setConfig(SEND_WAIT_IN_SECONDS, sendWaitInSeconds);
    }

    public URI getComponentURI() {
        Configuration modelConfiguration = this.getModelConfiguration();
        List children = modelConfiguration.getChildren();
        String baseUri = "mqtt://" + this.getName();
        QueryString queryStr = new QueryString();
        this.traverseConfiguration(children, queryStr, new String[]{NAME});
        return URI.create(UnsafeUriCharactersEncoder.encode((String)(baseUri + queryStr.toString())));
    }

    public static enum QualityOfService {
        AtMostOnce,
        AtLeastOnce,
        ExactlyOnce;

    }
}

