/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jacob.vpu;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class Statistics {
    public long numCycles;
    public long totalRunTimeMs;
    public long channelsCreated;
    public long messagesSent;
    public long messagesRcvd;
    public long numContinuations;
    public long totalContinuationBytes;
    public long runQueueEntries;
    public long numReductionsComm;
    public long numReductionsStruct;
    public long totalClientTimeMs;
    public final Map<String, PerTargetStatistics> byTarget = new HashMap<String, PerTargetStatistics>();

    public double getAvgClientTimeMs() {
        return (double)this.totalClientTimeMs / (double)this.numCycles;
    }

    public double getAvgContinuationSize() {
        return (double)this.totalContinuationBytes / (double)this.numContinuations;
    }

    public double getAvgKernelTimeMs() {
        return (double)this.getKernelTimeMs() / (double)this.numCycles;
    }

    public double getAvgRunTimeMs() {
        return (double)this.totalRunTimeMs / (double)this.numCycles;
    }

    public long getKernelTimeMs() {
        return this.totalRunTimeMs - this.totalClientTimeMs;
    }

    public void incRunTime(String target, long runTimeMs) {
        PerTargetStatistics pts = this.target(target);
        ++pts.invocations;
        pts.totalRunTimeMs += runTimeMs;
        pts.minRunTimeMs = Math.min(pts.minRunTimeMs, runTimeMs);
        pts.maxRunTimeMs = Math.max(pts.maxRunTimeMs, runTimeMs);
    }

    public void printToStream(PrintStream ps) {
        ps.println("JACOB VPU Statistics:");
        Field[] fields = this.getClass().getFields();
        for (int i = 0; i < fields.length; ++i) {
            ps.print(fields[i].getName());
            ps.print(" = ");
            try {
                ps.println(fields[i].get(this));
                continue;
            }
            catch (Exception ex) {
                ps.println(ex.toString());
            }
        }
        Method[] meth = this.getClass().getMethods();
        for (int i = 0; i < meth.length; ++i) {
            if (!meth[i].getName().startsWith("get") || meth[i].getParameterTypes().length != 0) continue;
            ps.print(meth[i].getName().substring(3));
            ps.print(" = ");
            try {
                ps.println(meth[i].invoke((Object)this, (Object[])null));
                continue;
            }
            catch (Exception ex) {
                ps.println(ex.toString());
            }
        }
    }

    private PerTargetStatistics target(String target) {
        PerTargetStatistics pts = this.byTarget.get(target);
        if (pts == null) {
            pts = new PerTargetStatistics();
            this.byTarget.put(target, pts);
        }
        return pts;
    }

    public static final class PerTargetStatistics {
        public long invocations;
        public long totalRunTimeMs;
        public long minRunTimeMs = Long.MAX_VALUE;
        public long maxRunTimeMs = Long.MIN_VALUE;

        public double getAvgRunTimePerInvocation() {
            return (double)this.totalRunTimeMs / (double)this.invocations;
        }

        public String toString() {
            return "(n=" + this.invocations + ", total=" + this.totalRunTimeMs + "ms, avg=" + this.getAvgRunTimePerInvocation() + "ms, min=" + this.minRunTimeMs + "ms, max=" + this.maxRunTimeMs + "ms)";
        }
    }
}

