/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.version;

import java.net.URL;
import java.util.regex.Pattern;
import org.switchyard.common.version.QueryType;
import org.switchyard.common.version.Version;

public final class Query {
    private final QueryType _type;
    private final Pattern _pattern;

    public Query(QueryType type, Pattern pattern) {
        this._type = type;
        this._pattern = pattern;
    }

    public Query(QueryType type, String regex) {
        this(type, Pattern.compile(regex));
    }

    public QueryType getType() {
        return this._type;
    }

    public Pattern getPattern() {
        return this._pattern;
    }

    public boolean matches(Version version) {
        String input;
        switch (this.getType()) {
            case PROJECT_GROUP_ID: {
                input = version.getProject().getGroupId();
                break;
            }
            case PROJECT_ARTIFACT_ID: {
                input = version.getProject().getArtifactId();
                break;
            }
            case PROJECT_PACKAGING: {
                input = version.getProject().getPackaging();
                break;
            }
            case PROJECT_NAME: {
                input = version.getProject().getName();
                break;
            }
            case PROJECT_DESCRIPTION: {
                input = version.getProject().getDescription();
                break;
            }
            case PROJECT_URL: {
                URL pUrl = version.getProject().getURL();
                input = pUrl != null ? pUrl.toString() : null;
                break;
            }
            case PROJECT_VERSION: {
                input = version.getProject().getVersion();
                break;
            }
            case SPECIFICATION_TITLE: {
                input = version.getSpecification().getTitle();
                break;
            }
            case SPECIFICATION_VENDOR: {
                input = version.getSpecification().getVendor();
                break;
            }
            case SPECIFICATION_VERSION: {
                input = version.getSpecification().getVersion();
                break;
            }
            case IMPLEMENTATION_TITLE: {
                input = version.getImplementation().getTitle();
                break;
            }
            case IMPLEMENTATION_VENDOR: {
                input = version.getImplementation().getVendor();
                break;
            }
            case IMPLEMENTATION_VENDOR_ID: {
                input = version.getImplementation().getVendorId();
                break;
            }
            case IMPLEMENTATION_URL: {
                URL iUrl = version.getImplementation().getURL();
                input = iUrl != null ? iUrl.toString() : null;
                break;
            }
            case IMPLEMENTATION_VERSION: {
                input = version.getImplementation().getVersion();
                break;
            }
            default: {
                input = null;
            }
        }
        return input != null ? this.getPattern().matcher(input).matches() : false;
    }
}

