/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.bdi.breaks.Breakpoint;
import org.apache.ode.bpel.common.ProcessState;
import org.apache.ode.bpel.engine.BpelDatabase;
import org.apache.ode.bpel.engine.BpelProcess;
import org.apache.ode.bpel.engine.BpelProcessDatabase;
import org.apache.ode.bpel.engine.Messages;
import org.apache.ode.bpel.evt.ActivityExecStartEvent;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.evt.ProcessCompletionEvent;
import org.apache.ode.bpel.evt.ProcessInstanceEvent;
import org.apache.ode.bpel.evt.ProcessInstanceStateChangeEvent;
import org.apache.ode.bpel.evt.ProcessTerminationEvent;
import org.apache.ode.bpel.evt.ScopeCompletionEvent;
import org.apache.ode.bpel.iapi.DebuggerContext;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.bpel.pmapi.InstanceNotFoundException;
import org.apache.ode.bpel.pmapi.ManagementException;
import org.apache.ode.bpel.pmapi.ProcessingException;
import org.apache.ode.bpel.runtime.breaks.BreakpointImpl;
import org.apache.ode.dao.bpel.BpelDAOConnection;
import org.apache.ode.dao.bpel.ProcessDAO;
import org.apache.ode.dao.bpel.ProcessInstanceDAO;
import org.apache.ode.utils.CollectionUtils;
import org.apache.ode.utils.msg.MessageBundle;

public class DebuggerSupport
implements DebuggerContext {
    private static final Log __log = LogFactory.getLog(DebuggerSupport.class);
    private static final Messages __msgs = (Messages)MessageBundle.getMessages(Messages.class);
    static final Breakpoint[] EMPTY_BP = new Breakpoint[0];
    private boolean _enabled = true;
    private Breakpoint[] _globalBreakPoints = EMPTY_BP;
    private final Set<Long> _step = new HashSet<Long>();
    private final Map<Long, Breakpoint[]> _instanceBreakPoints = new HashMap<Long, Breakpoint[]>();
    private BpelProcessDatabase _db;
    private BpelProcess _process;

    protected DebuggerSupport(BpelProcess process) {
        this._process = process;
        this._db = new BpelProcessDatabase(this._process._engine._contexts.dao, this._process._engine._contexts.scheduler, this._process._pid);
    }

    public void enable(boolean enabled) {
        this._enabled = enabled;
    }

    public Breakpoint[] getGlobalBreakpoints() {
        return this._globalBreakPoints;
    }

    public Breakpoint[] getBreakpoints(Long pid) {
        Breakpoint[] arr = this._instanceBreakPoints.get(pid);
        return arr == null ? EMPTY_BP : arr;
    }

    public void addGlobalBreakpoint(Breakpoint breakpoint) {
        Collection c = CollectionUtils.makeCollection(ArrayList.class, (Object[])this._globalBreakPoints);
        c.add(breakpoint);
        this._globalBreakPoints = c.toArray(new Breakpoint[c.size()]);
    }

    public void addBreakpoint(Long pid, Breakpoint breakpoint) {
        Object[] bpArr = this._instanceBreakPoints.get(pid);
        if (bpArr == null) {
            bpArr = new Breakpoint[]{breakpoint};
        } else {
            Collection c = CollectionUtils.makeCollection(ArrayList.class, (Object[])bpArr);
            c.add(breakpoint);
            bpArr = c.toArray(new Breakpoint[c.size()]);
        }
        this._instanceBreakPoints.put(pid, (Breakpoint[])bpArr);
    }

    public void removeGlobalBreakpoint(Breakpoint breakpoint) {
        Collection c = CollectionUtils.makeCollection(ArrayList.class, (Object[])this._globalBreakPoints);
        c.remove(breakpoint);
        this._globalBreakPoints = c.toArray(new Breakpoint[c.size()]);
    }

    public void removeBreakpoint(Long pid, Breakpoint breakpoint) {
        Object[] bpArr = this._instanceBreakPoints.get(pid);
        if (bpArr != null) {
            Collection c = CollectionUtils.makeCollection(ArrayList.class, (Object[])bpArr);
            c.remove(breakpoint);
            bpArr = c.toArray(new Breakpoint[c.size()]);
            if (bpArr.length == 0) {
                this._instanceBreakPoints.remove(pid);
            } else {
                this._instanceBreakPoints.put(pid, (Breakpoint[])bpArr);
            }
        }
    }

    public boolean step(final Long iid) {
        boolean doit = false;
        try {
            doit = this._db.exec(new BpelDatabase.Callable<Boolean>(){

                @Override
                public Boolean run(BpelDAOConnection conn) throws Exception {
                    ProcessInstanceDAO instance = conn.getInstance(iid);
                    if (instance == null) {
                        throw new InstanceNotFoundException("" + iid);
                    }
                    if (50 == instance.getState()) {
                        ProcessInstanceStateChangeEvent evt = new ProcessInstanceStateChangeEvent();
                        evt.setOldState((short)50);
                        short previousState = instance.getPreviousState();
                        instance.setState(previousState);
                        evt.setNewState(previousState);
                        evt.setProcessInstanceId(iid);
                        evt.setProcessName(instance.getProcess().getType());
                        evt.setProcessId(DebuggerSupport.this._db.getProcessId());
                        DebuggerSupport.this._process.saveEvent((ProcessInstanceEvent)evt, instance);
                        DebuggerSupport.this.onEvent((BpelEvent)evt);
                        __log.debug((Object)("step(" + iid + ") adding step indicator to table."));
                        DebuggerSupport.this._step.add(iid);
                        Scheduler.JobDetails we = new Scheduler.JobDetails();
                        we.setInstanceId(iid);
                        we.setType(Scheduler.JobType.RESUME);
                        ((DebuggerSupport)DebuggerSupport.this)._process._engine._contexts.scheduler.schedulePersistedJob(we, null);
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (InstanceNotFoundException infe) {
            throw infe;
        }
        catch (Exception ex) {
            __log.error((Object)"UnexpectedEx", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        return doit;
    }

    public void onEvent(BpelEvent event) {
        if (this._enabled && event instanceof ProcessInstanceEvent && !(event instanceof ProcessInstanceStateChangeEvent)) {
            Breakpoint[] bp;
            ProcessInstanceEvent evt = (ProcessInstanceEvent)event;
            if (evt instanceof ProcessCompletionEvent || evt instanceof ProcessTerminationEvent) {
                this._step.remove(evt.getProcessInstanceId());
                this._instanceBreakPoints.remove(evt.getProcessInstanceId());
                return;
            }
            boolean suspend = this.checkStep(evt);
            if (!suspend) {
                suspend = this.checkBreakPoints(evt, this._globalBreakPoints);
            }
            if (!suspend && (bp = this._instanceBreakPoints.get(evt.getProcessInstanceId())) != null) {
                suspend = this.checkBreakPoints(evt, bp);
            }
            if (suspend) {
                this._step.remove(evt.getProcessInstanceId());
                try {
                    ProcessDAO process = this._db.getProcessDAO();
                    ProcessInstanceDAO instance = process.getInstance(evt.getProcessInstanceId());
                    if (ProcessState.canExecute((short)instance.getState())) {
                        ProcessInstanceStateChangeEvent changeEvent = new ProcessInstanceStateChangeEvent();
                        changeEvent.setOldState(instance.getState());
                        instance.setState((short)50);
                        changeEvent.setNewState((short)50);
                        changeEvent.setProcessInstanceId(instance.getInstanceId());
                        changeEvent.setProcessName(process.getType());
                        changeEvent.setProcessId(this._db.getProcessId());
                        this._process.saveEvent((ProcessInstanceEvent)changeEvent, instance);
                        this.onEvent((BpelEvent)changeEvent);
                    }
                }
                catch (Exception dce) {
                    __log.error((Object)__msgs.msgDbError(), (Throwable)dce);
                }
            }
        }
    }

    private boolean checkStep(ProcessInstanceEvent event) {
        Long pid = event.getProcessInstanceId();
        return this._step.contains(pid) && (event instanceof ActivityExecStartEvent || event instanceof ScopeCompletionEvent);
    }

    private boolean checkBreakPoints(ProcessInstanceEvent event, Breakpoint[] breakpoints) {
        boolean suspended = false;
        for (int i = 0; i < breakpoints.length; ++i) {
            if (!((BreakpointImpl)breakpoints[i]).checkBreak((BpelEvent)event)) continue;
            suspended = true;
            break;
        }
        return suspended;
    }

    public boolean resume(final Long iid) {
        boolean doit = false;
        try {
            doit = this._db.exec(new BpelDatabase.Callable<Boolean>(){

                @Override
                public Boolean run(BpelDAOConnection conn) throws Exception {
                    ProcessInstanceDAO instance = conn.getInstance(iid);
                    if (instance == null) {
                        throw new InstanceNotFoundException("" + iid);
                    }
                    if (50 == instance.getState()) {
                        ProcessInstanceStateChangeEvent evt = new ProcessInstanceStateChangeEvent();
                        evt.setOldState((short)50);
                        short previousState = instance.getPreviousState();
                        instance.setState(previousState);
                        evt.setNewState(previousState);
                        evt.setProcessInstanceId(iid);
                        evt.setProcessName(instance.getProcess().getType());
                        evt.setProcessId(DebuggerSupport.this._db.getProcessId());
                        DebuggerSupport.this._process.saveEvent((ProcessInstanceEvent)evt, instance);
                        DebuggerSupport.this.onEvent((BpelEvent)evt);
                        Scheduler.JobDetails we = new Scheduler.JobDetails();
                        we.setType(Scheduler.JobType.RESUME);
                        we.setInstanceId(iid);
                        ((DebuggerSupport)DebuggerSupport.this)._process._engine._contexts.scheduler.schedulePersistedJob(we, null);
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (InstanceNotFoundException infe) {
            throw infe;
        }
        catch (Exception ex) {
            __log.error((Object)"ProcessingEx", (Throwable)ex);
            throw new ProcessingException(ex.getMessage(), (Throwable)ex);
        }
        return doit;
    }

    public void suspend(final Long iid) {
        try {
            this._db.exec(new BpelDatabase.Callable<Object>(){

                @Override
                public Object run(BpelDAOConnection conn) throws Exception {
                    ProcessInstanceDAO instance = conn.getInstance(iid);
                    if (instance == null) {
                        throw new InstanceNotFoundException("" + iid);
                    }
                    if (ProcessState.canExecute((short)instance.getState())) {
                        ProcessInstanceStateChangeEvent evt = new ProcessInstanceStateChangeEvent();
                        evt.setOldState(instance.getState());
                        instance.setState((short)50);
                        evt.setNewState((short)50);
                        evt.setProcessInstanceId(iid);
                        ProcessDAO process = instance.getProcess();
                        evt.setProcessName(process.getType());
                        evt.setProcessId(process.getProcessId());
                        DebuggerSupport.this._process.saveEvent((ProcessInstanceEvent)evt, instance);
                        DebuggerSupport.this.onEvent((BpelEvent)evt);
                    }
                    return null;
                }
            });
        }
        catch (ManagementException me) {
            throw me;
        }
        catch (Exception ex) {
            __log.error((Object)"DbError", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public void terminate(final Long iid) {
        try {
            this._db.exec(new BpelDatabase.Callable<Object>(){

                @Override
                public Object run(BpelDAOConnection conn) throws Exception {
                    ProcessInstanceDAO instance = conn.getInstance(iid);
                    if (instance == null) {
                        throw new ManagementException("InstanceNotFound:" + iid);
                    }
                    ProcessInstanceStateChangeEvent evt = new ProcessInstanceStateChangeEvent();
                    evt.setOldState(instance.getState());
                    instance.setState((short)60);
                    evt.setNewState((short)60);
                    evt.setProcessInstanceId(iid);
                    ProcessDAO process = instance.getProcess();
                    QName processName = process.getType();
                    evt.setProcessName(processName);
                    QName processId = process.getProcessId();
                    evt.setProcessId(processId);
                    DebuggerSupport.this._process.saveEvent((ProcessInstanceEvent)evt, instance);
                    ProcessTerminationEvent terminationEvent = new ProcessTerminationEvent();
                    terminationEvent.setProcessInstanceId(iid);
                    terminationEvent.setProcessName(processName);
                    terminationEvent.setProcessId(processId);
                    DebuggerSupport.this._process.saveEvent((ProcessInstanceEvent)evt, instance);
                    DebuggerSupport.this.onEvent((BpelEvent)evt);
                    DebuggerSupport.this.onEvent((BpelEvent)terminationEvent);
                    return null;
                }
            });
        }
        catch (ManagementException me) {
            throw me;
        }
        catch (Exception e) {
            __log.error((Object)"DbError", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Object getProcessModel() {
        return this._process.getOProcess();
    }
}

