/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.evtproc;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.ode.bpel.evt.ActivityEnabledEvent;
import org.apache.ode.bpel.evt.ActivityEvent;
import org.apache.ode.bpel.evt.ActivityExecEndEvent;
import org.apache.ode.bpel.evt.ActivityExecStartEvent;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.iapi.BpelEventListener;
import org.apache.ode.bpel.pmapi.ActivityInfoDocument;
import org.apache.ode.bpel.pmapi.TActivityInfo;
import org.apache.ode.bpel.pmapi.TActivityStatus;
import org.apache.ode.bpel.pmapi.TScopeRef;

public class ActivityStateDocumentBuilder
implements BpelEventListener {
    private HashMap<Long, ActivityInfoDocument> _activities = new HashMap();
    private ArrayList<ActivityInfoDocument> _activitiesOrdered = new ArrayList();
    private boolean _removeCompleted = false;
    private Long _scope;

    public List<ActivityInfoDocument> getActivities() {
        return this._activitiesOrdered;
    }

    public boolean isRemoveCompleted() {
        return this._removeCompleted;
    }

    public void setRemoveCompleted(boolean removeCompleted) {
        this._removeCompleted = removeCompleted;
    }

    public Long getScope() {
        return this._scope;
    }

    public void setScope(Long scope) {
        this._scope = scope;
    }

    public void onEvent(BpelEvent be) {
        if (be instanceof ActivityEvent) {
            ActivityEvent event = (ActivityEvent)be;
            ActivityInfoDocument actinf = this.lookup(event);
            assert (actinf != null);
            if (event instanceof ActivityEnabledEvent) {
                actinf.getActivityInfo().setStatus(TActivityStatus.ENABLED);
                Calendar dtEnabled = Calendar.getInstance();
                dtEnabled.setTime(event.getTimestamp());
                actinf.getActivityInfo().setDtEnabled(dtEnabled);
                this._activities.put(event.getActivityId(), actinf);
            }
            if (event instanceof ActivityExecStartEvent) {
                actinf.getActivityInfo().setStatus(TActivityStatus.STARTED);
                Calendar dtStarted = Calendar.getInstance();
                dtStarted.setTime(event.getTimestamp());
                actinf.getActivityInfo().setDtStarted(dtStarted);
            } else if (event instanceof ActivityExecEndEvent) {
                actinf.getActivityInfo().setStatus(TActivityStatus.COMPLETED);
                Calendar dtComp = Calendar.getInstance();
                dtComp.setTime(event.getTimestamp());
                actinf.getActivityInfo().setDtCompleted(dtComp);
                this.completed(actinf);
            }
        }
    }

    private void completed(ActivityInfoDocument ainf) {
        if (this._removeCompleted) {
            this._activitiesOrdered.remove(ainf);
            this._activities.values().remove(ainf);
        }
    }

    private ActivityInfoDocument lookup(ActivityEvent event) {
        ActivityInfoDocument ainf = this._activities.get(event.getActivityId());
        if (ainf == null) {
            ainf = ActivityInfoDocument.Factory.newInstance();
            this.fill(ainf.addNewActivityInfo(), event);
            ainf.getActivityInfo().setStatus(TActivityStatus.ENABLED);
            this._activities.put(event.getActivityId(), ainf);
            this._activitiesOrdered.add(ainf);
        }
        return ainf;
    }

    private void fill(TActivityInfo info, ActivityEvent event) {
        info.setName(event.getActivityName());
        info.setType(event.getActivityType());
        info.setAiid("" + event.getActivityId());
        info.setScope(TScopeRef.Factory.newInstance());
        info.getScope().setModelId("" + event.getScopeDeclarationId());
        info.getScope().setName(event.getScopeName());
        info.getScope().setSiid("" + event.getScopeId());
    }

    public void shutdown() {
    }

    public void startup(Properties configProperties) {
    }
}

