/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.deployment;

import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.weld.WeldDeploymentMarker;
import org.jboss.metadata.ear.spec.EarMetaData;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.switchyard.as7.extension.SwitchYardDeploymentMarker;
import org.switchyard.as7.extension.deployment.SwitchYardMetaData;

public class SwitchYardModuleDependencyProcessor
implements DeploymentUnitProcessor {
    private static final PathFilter META_INF_FILTER = PathFilters.isChildOf((String)"META-INF");
    private static final ModuleIdentifier SWITCHYARD_BEAN_ID = ModuleIdentifier.create((String)"org.switchyard.component.bean");
    private String _moduleId;

    public SwitchYardModuleDependencyProcessor(String moduleId) {
        this._moduleId = moduleId;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        ModuleIdentifier beanComponent;
        EarMetaData earConfig;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        if (!SwitchYardDeploymentMarker.isSwitchYardDeployment(deploymentUnit)) {
            return;
        }
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        ModuleDependency dep = new ModuleDependency(moduleLoader, ModuleIdentifier.fromString((String)this._moduleId), false, false, true, false);
        dep.addImportFilter(META_INF_FILTER, true);
        moduleSpecification.addSystemDependency(dep);
        if (WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit) && deploymentUnit.getParent() != null && (earConfig = (EarMetaData)deploymentUnit.getParent().getAttachment(org.jboss.as.ee.structure.Attachments.EAR_METADATA)) != null && (beanComponent = (ModuleIdentifier)deploymentUnit.getParent().getAttachment(SwitchYardMetaData.BEAN_COMPONENT_ATTACHMENT_KEY)) == null) {
            moduleLoader = Module.getBootModuleLoader();
            moduleSpecification = (ModuleSpecification)deploymentUnit.getParent().getAttachment(Attachments.MODULE_SPECIFICATION);
            dep = new ModuleDependency(moduleLoader, SWITCHYARD_BEAN_ID, false, false, true, false);
            dep.addImportFilter(META_INF_FILTER, true);
            moduleSpecification.addSystemDependency(dep);
            deploymentUnit.getParent().putAttachment(SwitchYardMetaData.BEAN_COMPONENT_ATTACHMENT_KEY, (Object)SWITCHYARD_BEAN_ID);
        }
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
    }
}

