/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.ws;

import java.util.HashMap;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.soap.MTOMFeature;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.metadata.webservices.PortComponentMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebserviceDescriptionMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;
import org.switchyard.ServiceDomain;
import org.switchyard.as7.extension.ws.JBossWSEndpoint;
import org.switchyard.component.common.Endpoint;
import org.switchyard.component.soap.InboundHandler;
import org.switchyard.component.soap.WebServicePublishException;
import org.switchyard.component.soap.config.model.SOAPBindingModel;
import org.switchyard.component.soap.endpoint.AbstractEndpointPublisher;

public class JBossWSEndpointPublisher
extends AbstractEndpointPublisher {
    private static final Logger LOGGER = Logger.getLogger((String)"org.switchyard");
    private static final String SEI = "org.switchyard.component.soap.endpoint.BaseWebService";
    private static final String RESPONSE_STATUS_HANDLER = "ResponseStatusHandler";

    public synchronized Endpoint publish(ServiceDomain domain, SOAPBindingModel config, String bindingId, InboundHandler handler, WebServiceFeature ... features) {
        JBossWSEndpoint wsEndpoint = null;
        try {
            this.initialize(config);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("/" + config.getPort().getServiceName(), SEI);
            Boolean addressingEnabled = false;
            Boolean addressingRequired = false;
            Boolean mtomEnabled = false;
            Integer mtomThreshold = -1;
            for (WebServiceFeature feature : features) {
                if (feature instanceof AddressingFeature) {
                    AddressingFeature addrFeature = (AddressingFeature)feature;
                    addressingEnabled = addrFeature.isEnabled();
                    addressingRequired = addrFeature.isRequired();
                    LOGGER.info((Object)("Addressing [enabled = " + addrFeature.isEnabled() + ", required = " + addrFeature.isRequired() + "]"));
                    continue;
                }
                if (!(feature instanceof MTOMFeature)) continue;
                MTOMFeature mtom = (MTOMFeature)feature;
                mtomEnabled = mtom.isEnabled();
                mtomThreshold = mtom.getThreshold();
                LOGGER.info((Object)("MTOM [enabled = " + mtom.isEnabled() + ", threshold = " + mtom.getThreshold() + "]"));
            }
            PortComponentMetaData portComponent = new PortComponentMetaData(config.getServiceName() + ":" + config.getPort().getServiceQName().getLocalPart() + ":" + config.getPort().getPortQName().getLocalPart(), config.getPort().getPortQName(), SEI, null, config.getPort().getServiceQName().getLocalPart(), null, "/" + config.getPort().getServiceName(), addressingEnabled.booleanValue(), addressingRequired.booleanValue(), "ALL", mtomEnabled.booleanValue(), mtomThreshold.intValue(), false, config.getPort().getServiceQName(), null, null);
            WebserviceDescriptionMetaData wsDescMetaData = new WebserviceDescriptionMetaData(config.getServiceName().getLocalPart(), this.getWsdlLocation(), null, new PortComponentMetaData[]{portComponent});
            WebservicesMetaData wsMetadata = new WebservicesMetaData(null, new WebserviceDescriptionMetaData[]{wsDescMetaData});
            wsEndpoint = new JBossWSEndpoint();
            if (config.getContextPath() != null) {
                wsEndpoint.publish(domain, this.getContextRoot(), map, wsMetadata, config, handler);
            } else {
                wsEndpoint.publish(domain, this.getContextPath(), map, wsMetadata, config, handler);
            }
        }
        catch (Exception e) {
            throw new WebServicePublishException((Throwable)e);
        }
        return wsEndpoint;
    }
}

