/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.monitor.model.metric;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import org.jboss.bpm.monitor.model.bpaf.Event;
import org.jboss.bpm.monitor.model.metric.Timespan;

public class Grouping {
    static TimeZone UTC = TimeZone.getTimeZone("Etc/UTC");

    private static SortedMap<Date, List<Event>> _doSort(List<Event> events, Timespan timespan, int calMetric) {
        long s0 = System.currentTimeMillis();
        TreeMap<Date, List<Event>> slotCount = new TreeMap<Date, List<Event>>();
        Calendar cal = Calendar.getInstance(UTC);
        cal.setTimeInMillis(timespan.getEnd());
        while (cal.getTimeInMillis() > timespan.getStart()) {
            slotCount.put(new Date(cal.getTimeInMillis()), new ArrayList());
            cal.add(calMetric, -1);
        }
        Set startingDates = slotCount.keySet();
        for (Date to : startingDates) {
            cal.setTime(to);
            cal.add(calMetric, -1);
            Date from = cal.getTime();
            for (Event e : events) {
                Date actual = new Date(e.getTimestamp());
                if (!actual.after(from) || !actual.before(to)) continue;
                ((List)slotCount.get(to)).add(e);
            }
        }
        return slotCount;
    }

    public static SortedMap<Date, List<Event>> byHour(List<Event> events, Timespan timespan) {
        return Grouping._doSort(events, timespan, 11);
    }

    public static SortedMap<Date, List<Event>> byDay(List<Event> events, Timespan timespan) {
        return Grouping._doSort(events, timespan, 6);
    }

    public static SortedMap<Date, List<Event>> byWeek(List<Event> events, Timespan timespan) {
        return Grouping._doSort(events, timespan, 3);
    }

    public static SortedMap<Date, List<Event>> byMonth(List<Event> events, Timespan timespan) {
        return Grouping._doSort(events, timespan, 2);
    }
}

