/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v22.datatype.AD;
import ca.uhn.hl7v2.model.v22.datatype.CE;
import ca.uhn.hl7v2.model.v22.datatype.ID;
import ca.uhn.hl7v2.model.v22.datatype.NM;
import ca.uhn.hl7v2.model.v22.datatype.ST;
import ca.uhn.hl7v2.model.v22.datatype.TN;
import ca.uhn.hl7v2.model.v22.datatype.TS;
import ca.uhn.hl7v2.model.v22.datatype.TX;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class OM1
extends AbstractSegment {
    public OM1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ST.class, false, 1, 3, new Object[]{this.getMessage()}, "Segment Type ID");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Sequence Number - Test/ Observation Master File");
            this.add(CE.class, true, 1, 200, new Object[]{this.getMessage()}, "Producer's test / observation ID");
            this.add(ID.class, false, 0, 12, new Object[]{this.getMessage(), new Integer(125)}, "Permitted Data Types");
            this.add(ID.class, true, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Specimen Required");
            this.add(CE.class, true, 1, 200, new Object[]{this.getMessage()}, "Producer ID");
            this.add(TX.class, false, 1, 200, new Object[]{this.getMessage()}, "Observation Description");
            this.add(CE.class, false, 1, 200, new Object[]{this.getMessage()}, "Other test / observation IDs for the observation");
            this.add(ST.class, true, 0, 200, new Object[]{this.getMessage()}, "Other Names");
            this.add(ST.class, false, 1, 30, new Object[]{this.getMessage()}, "Preferred Report Name for the Observation");
            this.add(ST.class, false, 1, 8, new Object[]{this.getMessage()}, "Preferred Short Name or Mnemonic for Observation");
            this.add(ST.class, false, 1, 200, new Object[]{this.getMessage()}, "Preferred Long Name for the Observation");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Orderability");
            this.add(CE.class, false, 0, 60, new Object[]{this.getMessage()}, "Identity of instrument used to perform this study");
            this.add(CE.class, false, 0, 200, new Object[]{this.getMessage()}, "Coded Representation of Method");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Portable");
            this.add(ID.class, false, 0, 1, new Object[]{this.getMessage(), new Integer(0)}, "Observation producing department / section");
            this.add(TN.class, false, 1, 40, new Object[]{this.getMessage()}, "Telephone Number of Section");
            this.add(ID.class, true, 1, 1, new Object[]{this.getMessage(), new Integer(174)}, "Nature of test / observation");
            this.add(CE.class, false, 1, 200, new Object[]{this.getMessage()}, "Report Subheader");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage()}, "Report Display Order");
            this.add(TS.class, true, 1, 26, new Object[]{this.getMessage()}, "Date / time stamp for any change in definition for obs");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Effective date / time of change");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Typical Turn-around Time");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Processing Time");
            this.add(ID.class, false, 0, 40, new Object[]{this.getMessage(), new Integer(168)}, "Processing Priority");
            this.add(ID.class, false, 1, 5, new Object[]{this.getMessage(), new Integer(169)}, "Reporting Priority");
            this.add(CE.class, false, 0, 200, new Object[]{this.getMessage()}, "Outside Site(s) Where Observation may be Performed");
            this.add(AD.class, false, 0, 1000, new Object[]{this.getMessage()}, "Address of Outside Site(s)");
            this.add(TN.class, false, 0, 400, new Object[]{this.getMessage()}, "Phone Number of Outside Site");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(177)}, "Confidentiality Code");
            this.add(CE.class, false, 0, 200, new Object[]{this.getMessage()}, "Observations required to interpret the observation");
            this.add(TX.class, false, 1, 65536, new Object[]{this.getMessage()}, "Interpretation of Observations");
            this.add(CE.class, false, 0, 65536, new Object[]{this.getMessage()}, "Contraindications to Observations");
            this.add(CE.class, false, 0, 200, new Object[]{this.getMessage()}, "Reflex tests / observations");
            this.add(ST.class, false, 1, 80, new Object[]{this.getMessage()}, "Rules that Trigger Reflex Testing");
            this.add(CE.class, false, 0, 65536, new Object[]{this.getMessage()}, "Fixed Canned Message");
            this.add(TX.class, false, 1, 200, new Object[]{this.getMessage()}, "Patient Preparation");
            this.add(CE.class, false, 1, 200, new Object[]{this.getMessage()}, "Procedure Medication");
            this.add(TX.class, false, 1, 200, new Object[]{this.getMessage()}, "Factors that may affect the observation");
            this.add(ST.class, false, 0, 60, new Object[]{this.getMessage()}, "Test / observation performance schedule");
            this.add(TX.class, false, 1, 65536, new Object[]{this.getMessage()}, "Description of Test Methods");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating OM1 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public ST getSegmentTypeID() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getOm11_SegmentTypeID() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getSequenceNumberTestObservationMasterFile() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public NM getOm12_SequenceNumberTestObservationMasterFile() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getProducerSTestObservationID() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getOm13_ProducerSTestObservationID() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public ID[] getPermittedDataTypes() {
        ID[] retVal = (ID[])this.getTypedField(4, new ID[0]);
        return retVal;
    }

    public ID[] getOm14_PermittedDataTypes() {
        ID[] retVal = (ID[])this.getTypedField(4, new ID[0]);
        return retVal;
    }

    public int getPermittedDataTypesReps() {
        return this.getReps(4);
    }

    public ID getPermittedDataTypes(int rep) {
        ID retVal = (ID)this.getTypedField(4, rep);
        return retVal;
    }

    public ID getOm14_PermittedDataTypes(int rep) {
        ID retVal = (ID)this.getTypedField(4, rep);
        return retVal;
    }

    public int getOm14_PermittedDataTypesReps() {
        return this.getReps(4);
    }

    public ID insertPermittedDataTypes(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(4, rep);
    }

    public ID insertOm14_PermittedDataTypes(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(4, rep);
    }

    public ID removePermittedDataTypes(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(4, rep);
    }

    public ID removeOm14_PermittedDataTypes(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(4, rep);
    }

    public ID getSpecimenRequired() {
        ID retVal = (ID)this.getTypedField(5, 0);
        return retVal;
    }

    public ID getOm15_SpecimenRequired() {
        ID retVal = (ID)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getProducerID() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getOm16_ProducerID() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public TX getObservationDescription() {
        TX retVal = (TX)this.getTypedField(7, 0);
        return retVal;
    }

    public TX getOm17_ObservationDescription() {
        TX retVal = (TX)this.getTypedField(7, 0);
        return retVal;
    }

    public CE getOtherTestObservationIDsForTheObservation() {
        CE retVal = (CE)this.getTypedField(8, 0);
        return retVal;
    }

    public CE getOm18_OtherTestObservationIDsForTheObservation() {
        CE retVal = (CE)this.getTypedField(8, 0);
        return retVal;
    }

    public ST[] getOtherNames() {
        ST[] retVal = (ST[])this.getTypedField(9, new ST[0]);
        return retVal;
    }

    public ST[] getOm19_OtherNames() {
        ST[] retVal = (ST[])this.getTypedField(9, new ST[0]);
        return retVal;
    }

    public int getOtherNamesReps() {
        return this.getReps(9);
    }

    public ST getOtherNames(int rep) {
        ST retVal = (ST)this.getTypedField(9, rep);
        return retVal;
    }

    public ST getOm19_OtherNames(int rep) {
        ST retVal = (ST)this.getTypedField(9, rep);
        return retVal;
    }

    public int getOm19_OtherNamesReps() {
        return this.getReps(9);
    }

    public ST insertOtherNames(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(9, rep);
    }

    public ST insertOm19_OtherNames(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(9, rep);
    }

    public ST removeOtherNames(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(9, rep);
    }

    public ST removeOm19_OtherNames(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(9, rep);
    }

    public ST getPreferredReportNameForTheObservation() {
        ST retVal = (ST)this.getTypedField(10, 0);
        return retVal;
    }

    public ST getOm110_PreferredReportNameForTheObservation() {
        ST retVal = (ST)this.getTypedField(10, 0);
        return retVal;
    }

    public ST getPreferredShortNameOrMnemonicForObservation() {
        ST retVal = (ST)this.getTypedField(11, 0);
        return retVal;
    }

    public ST getOm111_PreferredShortNameOrMnemonicForObservation() {
        ST retVal = (ST)this.getTypedField(11, 0);
        return retVal;
    }

    public ST getPreferredLongNameForTheObservation() {
        ST retVal = (ST)this.getTypedField(12, 0);
        return retVal;
    }

    public ST getOm112_PreferredLongNameForTheObservation() {
        ST retVal = (ST)this.getTypedField(12, 0);
        return retVal;
    }

    public ID getOrderability() {
        ID retVal = (ID)this.getTypedField(13, 0);
        return retVal;
    }

    public ID getOm113_Orderability() {
        ID retVal = (ID)this.getTypedField(13, 0);
        return retVal;
    }

    public CE[] getIdentityOfInstrumentUsedToPerformThisStudy() {
        CE[] retVal = (CE[])this.getTypedField(14, new CE[0]);
        return retVal;
    }

    public CE[] getOm114_IdentityOfInstrumentUsedToPerformThisStudy() {
        CE[] retVal = (CE[])this.getTypedField(14, new CE[0]);
        return retVal;
    }

    public int getIdentityOfInstrumentUsedToPerformThisStudyReps() {
        return this.getReps(14);
    }

    public CE getIdentityOfInstrumentUsedToPerformThisStudy(int rep) {
        CE retVal = (CE)this.getTypedField(14, rep);
        return retVal;
    }

    public CE getOm114_IdentityOfInstrumentUsedToPerformThisStudy(int rep) {
        CE retVal = (CE)this.getTypedField(14, rep);
        return retVal;
    }

    public int getOm114_IdentityOfInstrumentUsedToPerformThisStudyReps() {
        return this.getReps(14);
    }

    public CE insertIdentityOfInstrumentUsedToPerformThisStudy(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(14, rep);
    }

    public CE insertOm114_IdentityOfInstrumentUsedToPerformThisStudy(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(14, rep);
    }

    public CE removeIdentityOfInstrumentUsedToPerformThisStudy(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(14, rep);
    }

    public CE removeOm114_IdentityOfInstrumentUsedToPerformThisStudy(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(14, rep);
    }

    public CE[] getCodedRepresentationOfMethod() {
        CE[] retVal = (CE[])this.getTypedField(15, new CE[0]);
        return retVal;
    }

    public CE[] getOm115_CodedRepresentationOfMethod() {
        CE[] retVal = (CE[])this.getTypedField(15, new CE[0]);
        return retVal;
    }

    public int getCodedRepresentationOfMethodReps() {
        return this.getReps(15);
    }

    public CE getCodedRepresentationOfMethod(int rep) {
        CE retVal = (CE)this.getTypedField(15, rep);
        return retVal;
    }

    public CE getOm115_CodedRepresentationOfMethod(int rep) {
        CE retVal = (CE)this.getTypedField(15, rep);
        return retVal;
    }

    public int getOm115_CodedRepresentationOfMethodReps() {
        return this.getReps(15);
    }

    public CE insertCodedRepresentationOfMethod(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(15, rep);
    }

    public CE insertOm115_CodedRepresentationOfMethod(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(15, rep);
    }

    public CE removeCodedRepresentationOfMethod(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(15, rep);
    }

    public CE removeOm115_CodedRepresentationOfMethod(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(15, rep);
    }

    public ID getPortable() {
        ID retVal = (ID)this.getTypedField(16, 0);
        return retVal;
    }

    public ID getOm116_Portable() {
        ID retVal = (ID)this.getTypedField(16, 0);
        return retVal;
    }

    public ID[] getObservationProducingDepartmentSection() {
        ID[] retVal = (ID[])this.getTypedField(17, new ID[0]);
        return retVal;
    }

    public ID[] getOm117_ObservationProducingDepartmentSection() {
        ID[] retVal = (ID[])this.getTypedField(17, new ID[0]);
        return retVal;
    }

    public int getObservationProducingDepartmentSectionReps() {
        return this.getReps(17);
    }

    public ID getObservationProducingDepartmentSection(int rep) {
        ID retVal = (ID)this.getTypedField(17, rep);
        return retVal;
    }

    public ID getOm117_ObservationProducingDepartmentSection(int rep) {
        ID retVal = (ID)this.getTypedField(17, rep);
        return retVal;
    }

    public int getOm117_ObservationProducingDepartmentSectionReps() {
        return this.getReps(17);
    }

    public ID insertObservationProducingDepartmentSection(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(17, rep);
    }

    public ID insertOm117_ObservationProducingDepartmentSection(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(17, rep);
    }

    public ID removeObservationProducingDepartmentSection(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(17, rep);
    }

    public ID removeOm117_ObservationProducingDepartmentSection(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(17, rep);
    }

    public TN getTelephoneNumberOfSection() {
        TN retVal = (TN)this.getTypedField(18, 0);
        return retVal;
    }

    public TN getOm118_TelephoneNumberOfSection() {
        TN retVal = (TN)this.getTypedField(18, 0);
        return retVal;
    }

    public ID getNatureOfTestObservation() {
        ID retVal = (ID)this.getTypedField(19, 0);
        return retVal;
    }

    public ID getOm119_NatureOfTestObservation() {
        ID retVal = (ID)this.getTypedField(19, 0);
        return retVal;
    }

    public CE getReportSubheader() {
        CE retVal = (CE)this.getTypedField(20, 0);
        return retVal;
    }

    public CE getOm120_ReportSubheader() {
        CE retVal = (CE)this.getTypedField(20, 0);
        return retVal;
    }

    public ST getReportDisplayOrder() {
        ST retVal = (ST)this.getTypedField(21, 0);
        return retVal;
    }

    public ST getOm121_ReportDisplayOrder() {
        ST retVal = (ST)this.getTypedField(21, 0);
        return retVal;
    }

    public TS getDateTimeStampForAnyChangeInDefinitionForObs() {
        TS retVal = (TS)this.getTypedField(22, 0);
        return retVal;
    }

    public TS getOm122_DateTimeStampForAnyChangeInDefinitionForObs() {
        TS retVal = (TS)this.getTypedField(22, 0);
        return retVal;
    }

    public TS getEffectiveDateTimeOfChange() {
        TS retVal = (TS)this.getTypedField(23, 0);
        return retVal;
    }

    public TS getOm123_EffectiveDateTimeOfChange() {
        TS retVal = (TS)this.getTypedField(23, 0);
        return retVal;
    }

    public NM getTypicalTurnAroundTime() {
        NM retVal = (NM)this.getTypedField(24, 0);
        return retVal;
    }

    public NM getOm124_TypicalTurnAroundTime() {
        NM retVal = (NM)this.getTypedField(24, 0);
        return retVal;
    }

    public NM getProcessingTime() {
        NM retVal = (NM)this.getTypedField(25, 0);
        return retVal;
    }

    public NM getOm125_ProcessingTime() {
        NM retVal = (NM)this.getTypedField(25, 0);
        return retVal;
    }

    public ID[] getProcessingPriority() {
        ID[] retVal = (ID[])this.getTypedField(26, new ID[0]);
        return retVal;
    }

    public ID[] getOm126_ProcessingPriority() {
        ID[] retVal = (ID[])this.getTypedField(26, new ID[0]);
        return retVal;
    }

    public int getProcessingPriorityReps() {
        return this.getReps(26);
    }

    public ID getProcessingPriority(int rep) {
        ID retVal = (ID)this.getTypedField(26, rep);
        return retVal;
    }

    public ID getOm126_ProcessingPriority(int rep) {
        ID retVal = (ID)this.getTypedField(26, rep);
        return retVal;
    }

    public int getOm126_ProcessingPriorityReps() {
        return this.getReps(26);
    }

    public ID insertProcessingPriority(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(26, rep);
    }

    public ID insertOm126_ProcessingPriority(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(26, rep);
    }

    public ID removeProcessingPriority(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(26, rep);
    }

    public ID removeOm126_ProcessingPriority(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(26, rep);
    }

    public ID getReportingPriority() {
        ID retVal = (ID)this.getTypedField(27, 0);
        return retVal;
    }

    public ID getOm127_ReportingPriority() {
        ID retVal = (ID)this.getTypedField(27, 0);
        return retVal;
    }

    public CE[] getOutsideSiteSWhereObservationMayBePerformed() {
        CE[] retVal = (CE[])this.getTypedField(28, new CE[0]);
        return retVal;
    }

    public CE[] getOm128_OutsideSiteSWhereObservationMayBePerformed() {
        CE[] retVal = (CE[])this.getTypedField(28, new CE[0]);
        return retVal;
    }

    public int getOutsideSiteSWhereObservationMayBePerformedReps() {
        return this.getReps(28);
    }

    public CE getOutsideSiteSWhereObservationMayBePerformed(int rep) {
        CE retVal = (CE)this.getTypedField(28, rep);
        return retVal;
    }

    public CE getOm128_OutsideSiteSWhereObservationMayBePerformed(int rep) {
        CE retVal = (CE)this.getTypedField(28, rep);
        return retVal;
    }

    public int getOm128_OutsideSiteSWhereObservationMayBePerformedReps() {
        return this.getReps(28);
    }

    public CE insertOutsideSiteSWhereObservationMayBePerformed(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(28, rep);
    }

    public CE insertOm128_OutsideSiteSWhereObservationMayBePerformed(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(28, rep);
    }

    public CE removeOutsideSiteSWhereObservationMayBePerformed(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(28, rep);
    }

    public CE removeOm128_OutsideSiteSWhereObservationMayBePerformed(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(28, rep);
    }

    public AD[] getAddressOfOutsideSiteS() {
        AD[] retVal = (AD[])this.getTypedField(29, new AD[0]);
        return retVal;
    }

    public AD[] getOm129_AddressOfOutsideSiteS() {
        AD[] retVal = (AD[])this.getTypedField(29, new AD[0]);
        return retVal;
    }

    public int getAddressOfOutsideSiteSReps() {
        return this.getReps(29);
    }

    public AD getAddressOfOutsideSiteS(int rep) {
        AD retVal = (AD)this.getTypedField(29, rep);
        return retVal;
    }

    public AD getOm129_AddressOfOutsideSiteS(int rep) {
        AD retVal = (AD)this.getTypedField(29, rep);
        return retVal;
    }

    public int getOm129_AddressOfOutsideSiteSReps() {
        return this.getReps(29);
    }

    public AD insertAddressOfOutsideSiteS(int rep) throws HL7Exception {
        return (AD)super.insertRepetition(29, rep);
    }

    public AD insertOm129_AddressOfOutsideSiteS(int rep) throws HL7Exception {
        return (AD)super.insertRepetition(29, rep);
    }

    public AD removeAddressOfOutsideSiteS(int rep) throws HL7Exception {
        return (AD)super.removeRepetition(29, rep);
    }

    public AD removeOm129_AddressOfOutsideSiteS(int rep) throws HL7Exception {
        return (AD)super.removeRepetition(29, rep);
    }

    public TN[] getPhoneNumberOfOutsideSite() {
        TN[] retVal = (TN[])this.getTypedField(30, new TN[0]);
        return retVal;
    }

    public TN[] getOm130_PhoneNumberOfOutsideSite() {
        TN[] retVal = (TN[])this.getTypedField(30, new TN[0]);
        return retVal;
    }

    public int getPhoneNumberOfOutsideSiteReps() {
        return this.getReps(30);
    }

    public TN getPhoneNumberOfOutsideSite(int rep) {
        TN retVal = (TN)this.getTypedField(30, rep);
        return retVal;
    }

    public TN getOm130_PhoneNumberOfOutsideSite(int rep) {
        TN retVal = (TN)this.getTypedField(30, rep);
        return retVal;
    }

    public int getOm130_PhoneNumberOfOutsideSiteReps() {
        return this.getReps(30);
    }

    public TN insertPhoneNumberOfOutsideSite(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(30, rep);
    }

    public TN insertOm130_PhoneNumberOfOutsideSite(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(30, rep);
    }

    public TN removePhoneNumberOfOutsideSite(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(30, rep);
    }

    public TN removeOm130_PhoneNumberOfOutsideSite(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(30, rep);
    }

    public ID getConfidentialityCode() {
        ID retVal = (ID)this.getTypedField(31, 0);
        return retVal;
    }

    public ID getOm131_ConfidentialityCode() {
        ID retVal = (ID)this.getTypedField(31, 0);
        return retVal;
    }

    public CE[] getObservationsRequiredToInterpretTheObservation() {
        CE[] retVal = (CE[])this.getTypedField(32, new CE[0]);
        return retVal;
    }

    public CE[] getOm132_ObservationsRequiredToInterpretTheObservation() {
        CE[] retVal = (CE[])this.getTypedField(32, new CE[0]);
        return retVal;
    }

    public int getObservationsRequiredToInterpretTheObservationReps() {
        return this.getReps(32);
    }

    public CE getObservationsRequiredToInterpretTheObservation(int rep) {
        CE retVal = (CE)this.getTypedField(32, rep);
        return retVal;
    }

    public CE getOm132_ObservationsRequiredToInterpretTheObservation(int rep) {
        CE retVal = (CE)this.getTypedField(32, rep);
        return retVal;
    }

    public int getOm132_ObservationsRequiredToInterpretTheObservationReps() {
        return this.getReps(32);
    }

    public CE insertObservationsRequiredToInterpretTheObservation(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(32, rep);
    }

    public CE insertOm132_ObservationsRequiredToInterpretTheObservation(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(32, rep);
    }

    public CE removeObservationsRequiredToInterpretTheObservation(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(32, rep);
    }

    public CE removeOm132_ObservationsRequiredToInterpretTheObservation(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(32, rep);
    }

    public TX getInterpretationOfObservations() {
        TX retVal = (TX)this.getTypedField(33, 0);
        return retVal;
    }

    public TX getOm133_InterpretationOfObservations() {
        TX retVal = (TX)this.getTypedField(33, 0);
        return retVal;
    }

    public CE[] getContraindicationsToObservations() {
        CE[] retVal = (CE[])this.getTypedField(34, new CE[0]);
        return retVal;
    }

    public CE[] getOm134_ContraindicationsToObservations() {
        CE[] retVal = (CE[])this.getTypedField(34, new CE[0]);
        return retVal;
    }

    public int getContraindicationsToObservationsReps() {
        return this.getReps(34);
    }

    public CE getContraindicationsToObservations(int rep) {
        CE retVal = (CE)this.getTypedField(34, rep);
        return retVal;
    }

    public CE getOm134_ContraindicationsToObservations(int rep) {
        CE retVal = (CE)this.getTypedField(34, rep);
        return retVal;
    }

    public int getOm134_ContraindicationsToObservationsReps() {
        return this.getReps(34);
    }

    public CE insertContraindicationsToObservations(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(34, rep);
    }

    public CE insertOm134_ContraindicationsToObservations(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(34, rep);
    }

    public CE removeContraindicationsToObservations(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(34, rep);
    }

    public CE removeOm134_ContraindicationsToObservations(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(34, rep);
    }

    public CE[] getReflexTestsObservations() {
        CE[] retVal = (CE[])this.getTypedField(35, new CE[0]);
        return retVal;
    }

    public CE[] getOm135_ReflexTestsObservations() {
        CE[] retVal = (CE[])this.getTypedField(35, new CE[0]);
        return retVal;
    }

    public int getReflexTestsObservationsReps() {
        return this.getReps(35);
    }

    public CE getReflexTestsObservations(int rep) {
        CE retVal = (CE)this.getTypedField(35, rep);
        return retVal;
    }

    public CE getOm135_ReflexTestsObservations(int rep) {
        CE retVal = (CE)this.getTypedField(35, rep);
        return retVal;
    }

    public int getOm135_ReflexTestsObservationsReps() {
        return this.getReps(35);
    }

    public CE insertReflexTestsObservations(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(35, rep);
    }

    public CE insertOm135_ReflexTestsObservations(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(35, rep);
    }

    public CE removeReflexTestsObservations(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(35, rep);
    }

    public CE removeOm135_ReflexTestsObservations(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(35, rep);
    }

    public ST getRulesThatTriggerReflexTesting() {
        ST retVal = (ST)this.getTypedField(36, 0);
        return retVal;
    }

    public ST getOm136_RulesThatTriggerReflexTesting() {
        ST retVal = (ST)this.getTypedField(36, 0);
        return retVal;
    }

    public CE[] getFixedCannedMessage() {
        CE[] retVal = (CE[])this.getTypedField(37, new CE[0]);
        return retVal;
    }

    public CE[] getOm137_FixedCannedMessage() {
        CE[] retVal = (CE[])this.getTypedField(37, new CE[0]);
        return retVal;
    }

    public int getFixedCannedMessageReps() {
        return this.getReps(37);
    }

    public CE getFixedCannedMessage(int rep) {
        CE retVal = (CE)this.getTypedField(37, rep);
        return retVal;
    }

    public CE getOm137_FixedCannedMessage(int rep) {
        CE retVal = (CE)this.getTypedField(37, rep);
        return retVal;
    }

    public int getOm137_FixedCannedMessageReps() {
        return this.getReps(37);
    }

    public CE insertFixedCannedMessage(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(37, rep);
    }

    public CE insertOm137_FixedCannedMessage(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(37, rep);
    }

    public CE removeFixedCannedMessage(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(37, rep);
    }

    public CE removeOm137_FixedCannedMessage(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(37, rep);
    }

    public TX getPatientPreparation() {
        TX retVal = (TX)this.getTypedField(38, 0);
        return retVal;
    }

    public TX getOm138_PatientPreparation() {
        TX retVal = (TX)this.getTypedField(38, 0);
        return retVal;
    }

    public CE getProcedureMedication() {
        CE retVal = (CE)this.getTypedField(39, 0);
        return retVal;
    }

    public CE getOm139_ProcedureMedication() {
        CE retVal = (CE)this.getTypedField(39, 0);
        return retVal;
    }

    public TX getFactorsThatMayAffectTheObservation() {
        TX retVal = (TX)this.getTypedField(40, 0);
        return retVal;
    }

    public TX getOm140_FactorsThatMayAffectTheObservation() {
        TX retVal = (TX)this.getTypedField(40, 0);
        return retVal;
    }

    public ST[] getTestObservationPerformanceSchedule() {
        ST[] retVal = (ST[])this.getTypedField(41, new ST[0]);
        return retVal;
    }

    public ST[] getOm141_TestObservationPerformanceSchedule() {
        ST[] retVal = (ST[])this.getTypedField(41, new ST[0]);
        return retVal;
    }

    public int getTestObservationPerformanceScheduleReps() {
        return this.getReps(41);
    }

    public ST getTestObservationPerformanceSchedule(int rep) {
        ST retVal = (ST)this.getTypedField(41, rep);
        return retVal;
    }

    public ST getOm141_TestObservationPerformanceSchedule(int rep) {
        ST retVal = (ST)this.getTypedField(41, rep);
        return retVal;
    }

    public int getOm141_TestObservationPerformanceScheduleReps() {
        return this.getReps(41);
    }

    public ST insertTestObservationPerformanceSchedule(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(41, rep);
    }

    public ST insertOm141_TestObservationPerformanceSchedule(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(41, rep);
    }

    public ST removeTestObservationPerformanceSchedule(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(41, rep);
    }

    public ST removeOm141_TestObservationPerformanceSchedule(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(41, rep);
    }

    public TX getDescriptionOfTestMethods() {
        TX retVal = (TX)this.getTypedField(42, 0);
        return retVal;
    }

    public TX getOm142_DescriptionOfTestMethods() {
        TX retVal = (TX)this.getTypedField(42, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ST(this.getMessage());
            }
            case 1: {
                return new NM(this.getMessage());
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new ID(this.getMessage(), new Integer(125));
            }
            case 4: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 5: {
                return new CE(this.getMessage());
            }
            case 6: {
                return new TX(this.getMessage());
            }
            case 7: {
                return new CE(this.getMessage());
            }
            case 8: {
                return new ST(this.getMessage());
            }
            case 9: {
                return new ST(this.getMessage());
            }
            case 10: {
                return new ST(this.getMessage());
            }
            case 11: {
                return new ST(this.getMessage());
            }
            case 12: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 13: {
                return new CE(this.getMessage());
            }
            case 14: {
                return new CE(this.getMessage());
            }
            case 15: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 16: {
                return new ID(this.getMessage(), new Integer(0));
            }
            case 17: {
                return new TN(this.getMessage());
            }
            case 18: {
                return new ID(this.getMessage(), new Integer(174));
            }
            case 19: {
                return new CE(this.getMessage());
            }
            case 20: {
                return new ST(this.getMessage());
            }
            case 21: {
                return new TS(this.getMessage());
            }
            case 22: {
                return new TS(this.getMessage());
            }
            case 23: {
                return new NM(this.getMessage());
            }
            case 24: {
                return new NM(this.getMessage());
            }
            case 25: {
                return new ID(this.getMessage(), new Integer(168));
            }
            case 26: {
                return new ID(this.getMessage(), new Integer(169));
            }
            case 27: {
                return new CE(this.getMessage());
            }
            case 28: {
                return new AD(this.getMessage());
            }
            case 29: {
                return new TN(this.getMessage());
            }
            case 30: {
                return new ID(this.getMessage(), new Integer(177));
            }
            case 31: {
                return new CE(this.getMessage());
            }
            case 32: {
                return new TX(this.getMessage());
            }
            case 33: {
                return new CE(this.getMessage());
            }
            case 34: {
                return new CE(this.getMessage());
            }
            case 35: {
                return new ST(this.getMessage());
            }
            case 36: {
                return new CE(this.getMessage());
            }
            case 37: {
                return new TX(this.getMessage());
            }
            case 38: {
                return new CE(this.getMessage());
            }
            case 39: {
                return new TX(this.getMessage());
            }
            case 40: {
                return new ST(this.getMessage());
            }
            case 41: {
                return new TX(this.getMessage());
            }
        }
        return null;
    }
}

