/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v23.group.MFK_M01_MF;
import ca.uhn.hl7v2.model.v23.segment.ERR;
import ca.uhn.hl7v2.model.v23.segment.MFA;
import ca.uhn.hl7v2.model.v23.segment.MFI;
import ca.uhn.hl7v2.model.v23.segment.MSA;
import ca.uhn.hl7v2.model.v23.segment.MSH;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MFK_M01
extends AbstractMessage {
    public MFK_M01() {
        this(new DefaultModelClassFactory());
    }

    public MFK_M01(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, true, false);
            this.add(MFI.class, true, false);
            this.add(ERR.class, false, false);
            this.add(MFA.class, false, true);
            this.add(MFI.class, true, false);
            this.add(MFK_M01_MF.class, true, true);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating MFK_M01 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.3";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public MSA getMSA() {
        return this.getTyped("MSA", MSA.class);
    }

    public MFI getMFI() {
        return this.getTyped("MFI", MFI.class);
    }

    public ERR getERR() {
        return this.getTyped("ERR", ERR.class);
    }

    public MFA getMFA() {
        return this.getTyped("MFA", MFA.class);
    }

    public MFA getMFA(int rep) {
        return this.getTyped("MFA", rep, MFA.class);
    }

    public int getMFAReps() {
        return this.getReps("MFA");
    }

    public List<MFA> getMFAAll() throws HL7Exception {
        return this.getAllAsList("MFA", MFA.class);
    }

    public void insertMFA(MFA structure, int rep) throws HL7Exception {
        super.insertRepetition("MFA", structure, rep);
    }

    public MFA insertMFA(int rep) throws HL7Exception {
        return (MFA)super.insertRepetition("MFA", rep);
    }

    public MFA removeMFA(int rep) throws HL7Exception {
        return (MFA)super.removeRepetition("MFA", rep);
    }

    public MFI getMFI2() {
        return this.getTyped("MFI2", MFI.class);
    }

    public MFK_M01_MF getMF() {
        return this.getTyped("MF", MFK_M01_MF.class);
    }

    public MFK_M01_MF getMF(int rep) {
        return this.getTyped("MF", rep, MFK_M01_MF.class);
    }

    public int getMFReps() {
        return this.getReps("MF");
    }

    public List<MFK_M01_MF> getMFAll() throws HL7Exception {
        return this.getAllAsList("MF", MFK_M01_MF.class);
    }

    public void insertMF(MFK_M01_MF structure, int rep) throws HL7Exception {
        super.insertRepetition("MF", structure, rep);
    }

    public MFK_M01_MF insertMF(int rep) throws HL7Exception {
        return (MFK_M01_MF)super.insertRepetition("MF", rep);
    }

    public MFK_M01_MF removeMF(int rep) throws HL7Exception {
        return (MFK_M01_MF)super.removeRepetition("MF", rep);
    }
}

